/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.write;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.bytes.blockfile.write.BlockfileWriterBuilder;
import io.datarouter.bytes.kvfile.blockformat.KvFileBlockFormat;
import io.datarouter.bytes.kvfile.io.KvFile;
import io.datarouter.bytes.kvfile.io.write.KvFileWriter;
import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.scanner.Threads;
import java.util.List;
import java.util.function.Supplier;

public class KvFileWriterBuilder<T> {
    private final BlockfileWriterBuilder<List<T>> blockfileWriterBuilder;
    private final KvFileBlockFormat kvBlockFormat;
    private BinaryDictionary headerUserDictionary = new BinaryDictionary();
    private Supplier<BinaryDictionary> footerUserDictionarySupplier = BinaryDictionary::new;

    public KvFileWriterBuilder(KvFile<T> kvFile, Codec<T, KvFileEntry> kvCodec, String pathAndFile, KvFileBlockFormat kvBlockFormat) {
        this.blockfileWriterBuilder = new BlockfileWriterBuilder<List>(kvFile.blockfile(), kvBlockFormat.newBlockCodec(kvCodec)::encodeAll, pathAndFile);
        this.kvBlockFormat = kvBlockFormat;
    }

    public KvFileWriterBuilder<T> setEncodeBatchSize(int encodeBatchSize) {
        this.blockfileWriterBuilder.setEncodeBatchSize(encodeBatchSize);
        return this;
    }

    public KvFileWriterBuilder<T> setEncodeThreads(Threads encodeThreads) {
        this.blockfileWriterBuilder.setEncodeThreads(encodeThreads);
        return this;
    }

    public KvFileWriterBuilder<T> setCompressor(BlockfileCompressor compressor) {
        this.blockfileWriterBuilder.setCompressor(compressor);
        return this;
    }

    public KvFileWriterBuilder<T> setChecksummer(BlockfileChecksummer checksummer) {
        this.blockfileWriterBuilder.setChecksummer(checksummer);
        return this;
    }

    public KvFileWriterBuilder<T> setMultipartWrite(boolean multipartWrite) {
        this.blockfileWriterBuilder.setMultipartWrite(multipartWrite);
        return this;
    }

    public KvFileWriterBuilder<T> disableMultipartWrite() {
        return this.setMultipartWrite(false);
    }

    public KvFileWriterBuilder<T> setWriteThreads(Threads writeThreads) {
        this.blockfileWriterBuilder.setWriteThreads(writeThreads);
        return this;
    }

    public KvFileWriterBuilder<T> setHeaderDictionary(BinaryDictionary headerDictionary) {
        this.headerUserDictionary = headerDictionary;
        return this;
    }

    public KvFileWriterBuilder<T> setFooterDictionarySupplier(Supplier<BinaryDictionary> footerDictionarySupplier) {
        this.footerUserDictionarySupplier = footerDictionarySupplier;
        return this;
    }

    public KvFileWriter<T> build() {
        KvFileWriter.KvFileWriterConfig<T> kvFileWriterConfig = new KvFileWriter.KvFileWriterConfig<T>(this.blockfileWriterBuilder, this.kvBlockFormat, this.headerUserDictionary, this.footerUserDictionarySupplier);
        return new KvFileWriter<T>(kvFileWriterConfig);
    }
}

