/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.write;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.blockfile.write.BlockfileWriter;
import io.datarouter.bytes.blockfile.write.BlockfileWriterBuilder;
import io.datarouter.bytes.kvfile.blockformat.KvFileBlockFormat;
import io.datarouter.bytes.kvfile.io.footer.KvFileFooter;
import io.datarouter.bytes.kvfile.io.header.KvFileHeader;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class KvFileWriter<T> {
    private final KvFileWriterConfig<T> params;
    private final AtomicLong kvCounter;

    public KvFileWriter(KvFileWriterConfig<T> params) {
        this.params = params;
        this.kvCounter = new AtomicLong();
    }

    public KvFileWriteResult write(Scanner<List<T>> blockBatches) {
        Scanner instrumentedBlockBatches = blockBatches.each(batch -> {
            long l = this.kvCounter.addAndGet(batch.size());
        });
        BlockfileWriter<List<T>> blockfileWriter = this.params.blockfileWriterBuilder().setHeaderDictionary(this.makeHeaderDictionary()).setFooterDictionarySupplier(this::makeFooterDictionary).build();
        BlockfileWriter.BlockfileWriteResult blockfileWriteResult = blockfileWriter.write(instrumentedBlockBatches);
        return new KvFileWriteResult(blockfileWriteResult, this.kvCounter.get());
    }

    private BinaryDictionary makeHeaderDictionary() {
        KvFileHeader header = new KvFileHeader(this.params.headerUserDictionary(), this.params.blockFormat());
        return header.toBinaryDictionary();
    }

    private BinaryDictionary makeFooterDictionary() {
        KvFileFooter footer = new KvFileFooter(this.params.footerUserDictionarySupplier().get(), this.kvCounter.get());
        return KvFileFooter.DICTIONARY_CODEC.encode(footer);
    }

    public record KvFileWriteResult(BlockfileWriter.BlockfileWriteResult blockfileWriteResult, long kvCount) {
    }

    public record KvFileWriterConfig<T>(BlockfileWriterBuilder<List<T>> blockfileWriterBuilder, KvFileBlockFormat blockFormat, BinaryDictionary headerUserDictionary, Supplier<BinaryDictionary> footerUserDictionarySupplier) {
    }
}

