/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.header;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.bytes.kvfile.blockformat.KvFileBlockFormat;
import io.datarouter.bytes.kvfile.blockformat.KvFileBlockFormats;
import io.datarouter.bytes.kvfile.io.header.KvFileHeaderKey;

public record KvFileHeader(BinaryDictionary userDictionary, KvFileBlockFormat blockFormat) {
    public BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(KvFileHeaderKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(KvFileHeaderKey.KV_BLOCK_FORMAT.bytes, StringCodec.UTF_8.encode(this.blockFormat.encodedName()));
    }

    public static class KvFileHeaderCodec
    implements Codec<KvFileHeader, BinaryDictionary> {
        private final KvFileBlockFormats registeredBlockFormats;

        public KvFileHeaderCodec(KvFileBlockFormats registeredBlockFormats) {
            this.registeredBlockFormats = registeredBlockFormats;
        }

        @Override
        public BinaryDictionary encode(KvFileHeader value) {
            return value.toBinaryDictionary();
        }

        @Override
        public KvFileHeader decode(BinaryDictionary dictionary) {
            return new KvFileHeader(this.parseUserDictionary(dictionary), this.parseBlockFormat(dictionary));
        }

        private BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
            byte[] userDictionaryBytes = dictionary.get(KvFileHeaderKey.USER_DICTIONARY.bytes);
            return BinaryDictionary.decode(userDictionaryBytes);
        }

        private KvFileBlockFormat parseBlockFormat(BinaryDictionary dictionary) {
            byte[] blockFormatBytes = dictionary.get(KvFileHeaderKey.KV_BLOCK_FORMAT.bytes);
            String blockFormatString = StringCodec.UTF_8.decode(blockFormatBytes);
            return this.registeredBlockFormats.getForEncodedName(blockFormatString);
        }
    }
}

