/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.footer;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.kvfile.io.footer.KvFileFooterKey;
import io.datarouter.bytes.varint.VarIntTool;

public record KvFileFooter(BinaryDictionary userDictionary, long kvCount) {
    public static final Codec<KvFileFooter, BinaryDictionary> DICTIONARY_CODEC = Codec.of(KvFileFooter::toBinaryDictionary, KvFileFooter::fromBinaryDictionary);

    private BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(KvFileFooterKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(KvFileFooterKey.KV_COUNT.bytes, VarIntTool.encode(this.kvCount));
    }

    private static KvFileFooter fromBinaryDictionary(BinaryDictionary dictionary) {
        return new KvFileFooter(KvFileFooter.parseUserDictionary(dictionary), KvFileFooter.parseKvCount(dictionary));
    }

    private static BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
        byte[] userDictionaryBytes = dictionary.get(KvFileFooterKey.USER_DICTIONARY.bytes);
        return BinaryDictionary.decode(userDictionaryBytes);
    }

    private static long parseKvCount(BinaryDictionary dictionary) {
        byte[] kvCountBytes = dictionary.get(KvFileFooterKey.KV_COUNT.bytes);
        return VarIntTool.decodeLong(kvCountBytes);
    }
}

