/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.compact;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.dto.BlockfileNameAndSize;
import io.datarouter.bytes.kvfile.compact.KvFileCompactorFileCache;
import io.datarouter.bytes.kvfile.merge.KvFileMergePlan;
import io.datarouter.bytes.kvfile.merge.KvFileMerger;
import io.datarouter.bytes.kvfile.merge.KvFileMergerParams;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvFileCompactor {
    private static final Logger logger = LoggerFactory.getLogger(KvFileCompactor.class);
    private final KvFileCompactorParams params;
    private final KvFileCompactorFileCache fileCache;

    public KvFileCompactor(KvFileCompactorParams params) {
        this.params = params;
        this.fileCache = new KvFileCompactorFileCache(params.targetNumFiles(), params.prune(), params.mergerParams().readParams().readBufferSize(), params.mergerParams().readParams().memoryFanIn(), params.mergerParams().readParams().streamingFanIn(), this.listFilesInDirectory());
    }

    public void compact() {
        Scanner.generate(this.fileCache::findNextMergePlan).advanceWhile(Optional::isPresent).map(Optional::orElseThrow).forEach(this::merge);
    }

    private void merge(KvFileMergePlan plan) {
        logger.warn("startingMerging {}/{}->{}, inputSize={}, files={}", new Object[]{plan.files().size(), this.fileCache.numFiles(), this.fileCache.numFiles() - plan.files().size() + 1, BlockfileNameAndSize.totalSize(plan.files()).toDisplay(), KvFileCompactor.makeFileSummaryMessage(plan.files())});
        KvFileMerger merger = new KvFileMerger(this.params.mergerParams(), plan, ((Supplier<Boolean>)this.params.shouldStop())::get);
        BlockfileNameAndSize newFile = merger.merge();
        this.fileCache.add(newFile);
        Scanner.of(plan.files()).each(this.fileCache::remove).map(BlockfileNameAndSize::name).batch(1000).forEach(this.params.mergerParams().storageParams().blockfile().storage()::deleteMulti);
    }

    private List<BlockfileNameAndSize> listFilesInDirectory() {
        return this.params.mergerParams().storageParams().blockfile().storage().list();
    }

    private void validateFileCacheSize() {
        int numFilesInDirectory = this.listFilesInDirectory().size();
        if (this.fileCache.numFiles() != numFilesInDirectory) {
            String message = String.format("fileCacheSize=%s != filesInDirectory=%s", this.fileCache.numFiles(), numFilesInDirectory);
            throw new IllegalStateException(message);
        }
    }

    private static String makeFileSummaryMessage(List<BlockfileNameAndSize> files) {
        return (String)Scanner.of(files).map(file -> String.format("%s[%s]", file.name(), ByteLength.ofBytes(file.size()).toDisplay())).collect(Collectors.joining(", "));
    }

    public record KvFileCompactorParams(Supplier<Boolean> shouldStop, int targetNumFiles, boolean prune, KvFileMergerParams mergerParams) {
    }
}

