/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.blockformat;

import io.datarouter.bytes.kvfile.blockformat.KvFileBlockFormat;
import io.datarouter.bytes.kvfile.blockformat.KvFileStandardBlockFormats;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class KvFileBlockFormats {
    public final List<KvFileBlockFormat> all = new ArrayList<KvFileBlockFormat>(KvFileStandardBlockFormats.ALL);

    public KvFileBlockFormats add(KvFileBlockFormat format) {
        this.all.add(format);
        return this;
    }

    public KvFileBlockFormat getForEncodedName(String encodedName) {
        return (KvFileBlockFormat)Scanner.of(this.all).include(format -> format.encodedName().equals(encodedName)).findFirst().orElseThrow(() -> {
            String registeredNames = this.all.stream().map(KvFileBlockFormat::encodedName).collect(Collectors.joining(",", "[", "]"));
            String message = String.format("%s with name=%s is not registered.  registeredNames=%s", KvFileBlockFormat.class.getSimpleName(), encodedName, registeredNames);
            throw new IllegalArgumentException(message);
        });
    }
}

