/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.block;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.kvfile.block.KvFileBlockCodec;
import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.bytes.kvfile.kv.KvFileEntryCodec;
import io.datarouter.bytes.varint.VarIntTool;
import java.util.ArrayList;
import java.util.List;

public class KvFileSequentialBlockCodec<T>
implements KvFileBlockCodec<T> {
    private static final Codec<List<KvFileEntry>, byte[]> IDENTITY = Codec.of(new KvFileSequentialBlockCodec(Codec.identity())::encodeAll, new KvFileSequentialBlockCodec(Codec.identity())::decodeAll);
    private final Codec<T, KvFileEntry> kvCodec;

    public static Codec<List<KvFileEntry>, byte[]> identity() {
        return IDENTITY;
    }

    public KvFileSequentialBlockCodec(Codec<T, KvFileEntry> kvCodec) {
        this.kvCodec = kvCodec;
    }

    @Override
    public byte[] encodeAll(List<T> items) {
        int numSizeBytes = VarIntTool.length(items.size());
        int numDataBytes = 0;
        ArrayList<KvFileEntry> kvs = new ArrayList<KvFileEntry>(items.size());
        for (T item : items) {
            KvFileEntry kv = this.kvCodec.encode(item);
            kvs.add(kv);
            numDataBytes += kv.length();
        }
        int numBytes = numSizeBytes + numDataBytes;
        byte[] bytes = new byte[numBytes];
        int cursor = 0;
        cursor += VarIntTool.encode(bytes, cursor, kvs.size());
        for (KvFileEntry kv : kvs) {
            System.arraycopy(kv.backingBytes(), kv.offset(), bytes, cursor, kv.length());
            cursor += kv.length();
        }
        return bytes;
    }

    @Override
    public List<T> decodeAll(byte[] bytes) {
        int cursor = 0;
        int size = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(size);
        ArrayList<T> items = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            KvFileEntry kv = KvFileEntryCodec.fromBytes(bytes, cursor);
            cursor += kv.length();
            items.add(this.kvCodec.decode(kv));
            ++i;
        }
        return items;
    }
}

