/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.bytearray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.bytecodec.ComparableByteCodec;

public class ComparableByteArrayCodec {
    public static final ComparableByteArrayCodec INSTANCE = new ComparableByteArrayCodec();
    private static final ComparableByteCodec COMPARABLE_BYTE_CODEC = ComparableByteCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_BYTE_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(byte[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(byte[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_BYTE_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length;
    }

    public byte[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public byte[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.BYTE;
        }
        byte[] result = new byte[bytesLength];
        int cursor = offset;
        int i = 0;
        while (i < bytesLength) {
            result[i] = COMPARABLE_BYTE_CODEC.decode(bytes, cursor);
            ++cursor;
            ++i;
        }
        return result;
    }
}

