/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ReplacingFunction;
import java.util.function.Function;

public interface Codec<A, B> {
    public static final Codec<?, ?> IDENTITY_INSTANCE = Codec.of(Function.identity(), Function.identity());

    public B encode(A var1);

    public A decode(B var1);

    default public A encodeAndDecode(A value) {
        return this.decode(this.encode(value));
    }

    public static <A, B> Codec<A, B> of(Function<A, B> encodeFunction, Function<B, A> decodeFunction) {
        return new FunctionalCodec<A, B>(encodeFunction, decodeFunction);
    }

    public static <A> Codec<A, A> identity() {
        return IDENTITY_INSTANCE;
    }

    public static class FunctionalCodec<A, B>
    implements Codec<A, B> {
        private final Function<A, B> encodeFunction;
        private final Function<B, A> decodeFunction;

        public FunctionalCodec(Function<A, B> encodeFunction, Function<B, A> decodeFunction) {
            this.encodeFunction = encodeFunction;
            this.decodeFunction = decodeFunction;
        }

        @Override
        public B encode(A value) {
            return this.encodeFunction.apply(value);
        }

        @Override
        public A decode(B encodedValue) {
            return this.decodeFunction.apply(encodedValue);
        }
    }

    public static class NullPassthroughCodec<A, B>
    extends FunctionalCodec<A, B> {
        public NullPassthroughCodec(Function<A, B> encodeFunction, Function<B, A> decodeFunction) {
            super(ReplacingFunction.NullPassthroughFunction.of(encodeFunction), ReplacingFunction.NullPassthroughFunction.of(decodeFunction));
        }

        public static <A, B> NullPassthroughCodec<A, B> of(Function<A, B> encodeFunction, Function<B, A> decodeFunction) {
            return new NullPassthroughCodec<A, B>(encodeFunction, decodeFunction);
        }

        public static <A, B> NullPassthroughCodec<A, B> of(Codec<A, B> codec) {
            return new NullPassthroughCodec<Object, Object>(codec::encode, codec::decode);
        }
    }
}

