/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.varint.VarIntTool;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class ByteArrays
extends AbstractList<byte[]>
implements RandomAccess {
    private static final ByteArrays EMPTY = ByteArrays.of(List.of());
    protected final byte[] backingArray;
    protected final int offset;
    protected final int valuesOffset;
    protected final int[] endings;

    public static ByteArrays empty() {
        return EMPTY;
    }

    public static ByteArrays of(List<byte[]> inputArrays) {
        return new ByteArrays(inputArrays);
    }

    public static ByteArrays of(byte[] backingArray, int offset) {
        return new ByteArrays(backingArray, offset);
    }

    protected ByteArrays(List<byte[]> items) {
        Objects.requireNonNull(items);
        int size = items.size();
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(1 + size + size);
        int cursor = this.offset = 0;
        tokens.add(VarIntTool.encode(size));
        cursor += VarIntTool.length(size);
        for (byte[] item : items) {
            tokens.add(VarIntTool.encode(item.length));
            cursor += VarIntTool.length(item.length);
        }
        this.valuesOffset = cursor;
        this.endings = new int[size];
        int index = 0;
        for (byte[] item : items) {
            this.endings[index] = cursor += item.length;
            ++index;
        }
        tokens.addAll(items);
        this.backingArray = ByteTool.concat(tokens);
    }

    protected ByteArrays(byte[] backingArray, int offset) {
        this.backingArray = backingArray;
        this.offset = offset;
        int cursor = offset;
        int size = VarIntTool.decodeInt(backingArray, cursor);
        cursor += VarIntTool.length(size);
        this.endings = new int[size];
        int i = 0;
        while (i < size) {
            int length = VarIntTool.decodeInt(backingArray, cursor);
            cursor += VarIntTool.length(length);
            this.endings[i] = length;
            ++i;
        }
        this.valuesOffset = cursor;
        int endingCursor = cursor;
        int i2 = 0;
        while (i2 < size) {
            int length = this.endings[i2];
            this.endings[i2] = endingCursor += length;
            cursor += length;
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object other) {
        Object object = other;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] cfr_ignored_0 = (byte[])object;
            int size = this.size();
            int i = 0;
            while (i < size) {
                void target;
                if (this.equalsItem(i, (byte[])target)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public byte[] get(int index) {
        return Arrays.copyOfRange(this.backingArray, this.getFrom(index), this.getTo(index));
    }

    @Override
    public int size() {
        return this.endings.length;
    }

    public int getLength() {
        return this.getLastEnding() - this.offset;
    }

    public byte[] toBytes() {
        return this.coversFullBackingArray() ? this.backingArray : Arrays.copyOfRange(this.backingArray, this.offset, this.getLastEnding());
    }

    protected int getFrom(int index) {
        return index == 0 ? this.valuesOffset : this.endings[index - 1];
    }

    protected int getTo(int index) {
        return this.endings[index];
    }

    public int compareItem(int index, byte[] target) {
        return Arrays.compareUnsigned(this.backingArray, this.getFrom(index), this.getTo(index), target, 0, target.length);
    }

    public static int compareItem(ByteArrays arrays1, int index1, ByteArrays arrays2, int index2) {
        return Arrays.compareUnsigned(arrays1.backingArray, arrays1.getFrom(index1), arrays1.getTo(index1), arrays2.backingArray, arrays2.getFrom(index2), arrays2.getTo(index2));
    }

    protected boolean equalsItem(int index, byte[] target) {
        return Arrays.equals(this.backingArray, this.getFrom(index), this.getTo(index), target, 0, target.length);
    }

    private int getLastEnding() {
        return this.size() == 0 ? this.valuesOffset : this.endings[this.size() - 1];
    }

    private boolean coversFullBackingArray() {
        return this.offset == 0 && this.backingArray.length == this.getLastEnding();
    }
}

