/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.read;

import io.datarouter.bytes.blockfile.read.BlockfileReader;
import io.datarouter.bytes.blockfile.section.BlockfileFooter;
import io.datarouter.bytes.kvfile.io.footer.KvFileFooter;
import io.datarouter.bytes.kvfile.io.header.KvFileHeader;
import io.datarouter.bytes.kvfile.io.read.KvFileMetadataReader;
import io.datarouter.scanner.Scanner;
import java.util.List;

public class KvFileReader<T> {
    private final KvFileReaderConfig<T> config;

    public KvFileReader(KvFileReaderConfig<T> config) {
        this.config = config;
    }

    public KvFileHeader header() {
        return this.config.kvFileMetadataReader().header();
    }

    public Scanner<BlockfileReader.BlockfileDecodedBlockBatch<List<T>>> scanBlockfileDecodedBlockBatches() {
        return this.config.blockfileReader().scanDecodedBlockBatches();
    }

    public Scanner<List<List<T>>> scanBlockBatches() {
        return this.scanBlockfileDecodedBlockBatches().map(BlockfileReader.BlockfileDecodedBlockBatch::values);
    }

    public Scanner<BlockfileReader.BlockfileDecodedBlock<List<T>>> scanBlockfileDecodedBlocks() {
        return this.config.blockfileReader().scanDecodedBlocks();
    }

    public Scanner<List<T>> scanBlocks() {
        return this.scanBlockfileDecodedBlocks().map(BlockfileReader.BlockfileDecodedBlock::value);
    }

    public Scanner<T> scan() {
        return this.scanBlocks().concat(Scanner::of);
    }

    public BlockfileFooter blockfileFooter() {
        return this.config.blockfileReader().footer();
    }

    public KvFileFooter footer() {
        return this.config.kvFileMetadataReader().footer();
    }

    public record KvFileReaderConfig<T>(BlockfileReader<List<T>> blockfileReader, KvFileMetadataReader<T> kvFileMetadataReader) {
    }
}

