/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.bytes.kvfile.kv.KvFileOp;
import io.datarouter.bytes.varint.VarIntTool;

public class KvFileEntrySerializer {
    public static byte[] toBytes(byte[] key, byte[] version, KvFileOp op, byte[] value) {
        return ByteTool.concat(VarIntTool.encode(key.length), key, VarIntTool.encode(version.length), version, op.persistentValueArray, VarIntTool.encode(value.length), value);
    }

    public static KvFileEntry fromBytes(byte[] bytes, int offset) {
        int cursor = offset;
        int keyLength = VarIntTool.decodeInt(bytes, cursor);
        int keyOffset = cursor += VarIntTool.length(keyLength);
        int versionLength = VarIntTool.decodeInt(bytes, cursor += keyLength);
        int versionOffset = cursor += VarIntTool.length(versionLength);
        KvFileOp op = KvFileOp.fromByte(bytes[cursor += versionLength]);
        int valueLength = VarIntTool.decodeInt(bytes, ++cursor);
        int valueOffset = cursor += VarIntTool.length(valueLength);
        int length = (cursor += valueLength) - offset;
        return new KvFileEntry(bytes, offset, length, keyOffset, keyLength, versionOffset, versionLength, op, valueOffset, valueLength);
    }

    public static KvFileEntry fromBytes(byte[] bytes) {
        return KvFileEntrySerializer.fromBytes(bytes, 0);
    }
}

