/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.read;

import io.datarouter.bytes.blockfile.read.BlockfileMetadataCache;
import io.datarouter.bytes.blockfile.section.BlockfileFooter;
import io.datarouter.bytes.blockfile.section.BlockfileHeader;
import io.datarouter.bytes.blockfile.section.BlockfileTrailer;
import io.datarouter.bytes.blockfile.storage.BlockfileStorage;
import io.datarouter.bytes.blockfile.write.BlockfileWriter;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import java.util.Optional;

public class BlockfileMetadataReader<T> {
    private final BlockfileMetadataReaderConfig<T> config;
    private final String name;
    private final BlockfileMetadataCache<Long> cachedLength = new BlockfileMetadataCache<Long>(this::loadLength);
    private final BlockfileMetadataCache<DecodedHeader> cachedDecodedHeader = new BlockfileMetadataCache<DecodedHeader>(this::loadDecodedHeader);
    private final BlockfileMetadataCache<BlockfileFooter> cachedFooter = new BlockfileMetadataCache<BlockfileFooter>(this::loadFooter);
    private final BlockfileMetadataCache<BlockfileTrailer> cachedTrailer = new BlockfileMetadataCache<BlockfileTrailer>(this::loadTrailer);

    public BlockfileMetadataReader(BlockfileMetadataReaderConfig<T> config, String name) {
        this.config = config;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    private long loadLength() {
        return this.config.knownFileLength().orElseGet(() -> this.config.storage().length(this.name));
    }

    public int numBlockMetadataBytes() {
        return BlockfileWriter.NUM_VALUE_LENGTH_BYTES + this.header().checksummer().numBytes() + 1;
    }

    public int headerBlockLength() {
        return this.cachedDecodedHeader.get().blockLength();
    }

    public BlockfileHeader header() {
        return this.cachedDecodedHeader.get().header();
    }

    private DecodedHeader loadDecodedHeader() {
        byte[] blockLengthBytes = this.config.storage().readPartial(this.name, 0L, BlockfileWriter.NUM_VALUE_LENGTH_BYTES);
        int blockLength = RawIntCodec.INSTANCE.decode(blockLengthBytes);
        int valueLength = blockLength - BlockfileWriter.NUM_HEADER_METADATA_BYTES;
        byte[] valueBytes = this.config.storage().readPartial(this.name, BlockfileWriter.NUM_HEADER_METADATA_BYTES, valueLength);
        return new DecodedHeader(this.config.headerCodec().decode(valueBytes), blockLength);
    }

    public void setHeader(DecodedHeader decodedHeader) {
        this.cachedDecodedHeader.set(decodedHeader);
    }

    public BlockfileFooter footer() {
        return this.cachedFooter.get();
    }

    private BlockfileFooter loadFooter() {
        byte[] valueBytes = this.config.storage().readPartial(this.name, this.footerValueOffset(), this.footerValueLength());
        return BlockfileFooter.VALUE_CODEC.decode(valueBytes);
    }

    public long footerBlockOffset() {
        return this.cachedLength.get() - (long)BlockfileWriter.NUM_TRAILER_BYTES - (long)this.cachedTrailer.get().footerBlockLength();
    }

    public long footerValueOffset() {
        return this.footerBlockOffset() + (long)BlockfileWriter.NUM_FOOTER_METADATA_BYTES;
    }

    public int footerValueLength() {
        return this.cachedTrailer.get().footerBlockLength() - BlockfileWriter.NUM_FOOTER_METADATA_BYTES;
    }

    public BlockfileTrailer trailer() {
        return this.cachedTrailer.get();
    }

    private BlockfileTrailer loadTrailer() {
        byte[] trailerBytes = this.config.storage().readPartial(this.name, this.cachedLength.get() - (long)BlockfileWriter.NUM_TRAILER_BYTES, BlockfileWriter.NUM_TRAILER_BYTES);
        return BlockfileTrailer.decode(trailerBytes);
    }

    public record BlockfileMetadataReaderConfig<T>(BlockfileStorage storage, BlockfileHeader.BlockfileHeaderCodec headerCodec, Optional<Long> knownFileLength) {
    }

    public record DecodedHeader(BlockfileHeader header, int blockLength) {
    }
}

