/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.compress;

import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BlockfileCompressors {
    public final List<BlockfileCompressor> all;

    public BlockfileCompressors(List<BlockfileCompressor> all) {
        this.all = new ArrayList<BlockfileCompressor>(all);
    }

    public BlockfileCompressors add(BlockfileCompressor compressor) {
        this.all.add(compressor);
        return this;
    }

    public BlockfileCompressor getForEncodedName(String encodedName) {
        return (BlockfileCompressor)Scanner.of(this.all).include(compressor -> compressor.encodedName().equals(encodedName)).findFirst().orElseThrow(() -> {
            String registeredNames = this.all.stream().map(BlockfileCompressor::encodedName).collect(Collectors.joining(",", "[", "]"));
            String message = String.format("compressor with name=%s is not registered.  registeredCompressors=%s", encodedName, registeredNames);
            throw new IllegalArgumentException(message);
        });
    }
}

