/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io;

import io.datarouter.bytes.blockfile.Blockfile;
import io.datarouter.bytes.blockfile.BlockfileBuilder;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.bytes.blockfile.storage.BlockfileStorage;
import io.datarouter.bytes.kvfile.io.KvFile;
import java.util.ArrayList;
import java.util.List;

public class KvFileBuilder<T> {
    private final BlockfileBuilder<List<T>> blockfileBuilder;
    private final List<String> kvBlockFormats = new ArrayList<String>();

    public KvFileBuilder(BlockfileStorage blockfileStorage) {
        this.blockfileBuilder = new BlockfileBuilder(blockfileStorage);
    }

    public KvFileBuilder<T> registerChecksummer(BlockfileChecksummer checksummer) {
        this.blockfileBuilder.registerChecksummer(checksummer);
        return this;
    }

    public KvFileBuilder<T> registerCompressor(BlockfileCompressor compressor) {
        this.blockfileBuilder.registerCompressor(compressor);
        return this;
    }

    public KvFileBuilder<T> registerKvBlockFormat(String kvBlockFormat) {
        this.kvBlockFormats.add(kvBlockFormat);
        return this;
    }

    public KvFile<T> build() {
        Blockfile<List<T>> blockfile = this.blockfileBuilder.build();
        return new KvFile<T>(blockfile, this.kvBlockFormats);
    }
}

