/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.compress.gzip;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.io.InputStreamTool;
import io.datarouter.bytes.io.MultiByteArrayInputStream;
import io.datarouter.bytes.io.OutputStreamTool;
import io.datarouter.bytes.varint.VarIntTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipBlockStream {
    private static int DEFAULT_BLOCK_SIZE = ByteLength.ofKiB(8L).toBytesInt();
    private static int DEFAULT_ENCODER_BUFFER_SIZE = ByteLength.ofKiB(8L).toBytesInt();
    private static int DEFAULT_GZIP_BUFFER_SIZE = ByteLength.ofKiB(8L).toBytesInt();
    private static int DEFAULT_DECODER_BUFFER_SIZE = ByteLength.ofKiB(10L).toBytesInt();
    private final int blockSize;
    private final int encodeBufferSize;
    private final int gzipBufferSize;
    private final int decodeBufferSize;
    private final AtomicLong numBlocksEncoded;

    public GzipBlockStream() {
        this(DEFAULT_BLOCK_SIZE, DEFAULT_ENCODER_BUFFER_SIZE, DEFAULT_GZIP_BUFFER_SIZE, DEFAULT_DECODER_BUFFER_SIZE);
    }

    public GzipBlockStream(int blockSize) {
        this(blockSize, blockSize, DEFAULT_GZIP_BUFFER_SIZE, blockSize + ByteLength.ofKiB(2L).toBytesInt());
    }

    public GzipBlockStream(int blockSize, int encodeBufferSize, int gzipBufferSize, int decodeBufferSize) {
        this.blockSize = blockSize;
        this.encodeBufferSize = encodeBufferSize;
        this.gzipBufferSize = gzipBufferSize;
        this.decodeBufferSize = decodeBufferSize;
        this.numBlocksEncoded = new AtomicLong(0L);
    }

    public Scanner<GzipBlockStreamEncodedBlock> encode(Scanner<GzipBlockStreamRow> rows) {
        return rows.batchByMinSize((long)this.blockSize, GzipBlockStreamRow::length).map(this::encodeRowsToGzipBlock);
    }

    public Scanner<GzipBlockStreamEncodedBlock> encodeParallel(Scanner<GzipBlockStreamRow> rows, Threads threads) {
        return rows.batchByMinSize((long)this.blockSize, GzipBlockStreamRow::length).parallelOrdered(threads).map(this::encodeRowsToGzipBlock);
    }

    private GzipBlockStreamEncodedBlock encodeRowsToGzipBlock(List<GzipBlockStreamRow> rows) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.encodeBufferSize);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)byteArrayOutputStream, this.gzipBufferSize);){
                for (GzipBlockStreamRow row : rows) {
                    for (byte[] input : row.tokens()) {
                        gzipOutputStream.write(input);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.numBlocksEncoded.incrementAndGet();
        byte[] gzipBytes = byteArrayOutputStream.toByteArray();
        return new GzipBlockStreamEncodedBlock(gzipBytes);
    }

    public Scanner<byte[]> decode(InputStream inputStream) {
        return this.rawInputStreamToGzipBlocks(inputStream).map(this::gzipBlockToRawBlock);
    }

    public Scanner<byte[]> decodeParallel(InputStream inputStream, Threads threads) {
        return this.rawInputStreamToGzipBlocks(inputStream).parallelOrdered(threads).map(this::gzipBlockToRawBlock);
    }

    private Scanner<byte[]> rawInputStreamToGzipBlocks(InputStream rawInputStream) {
        return Scanner.generate(() -> VarIntTool.fromInputStreamInt(rawInputStream)).advanceWhile(Optional::isPresent).map(Optional::orElseThrow).map(length -> InputStreamTool.readNBytes(rawInputStream, length));
    }

    private byte[] gzipBlockToRawBlock(byte[] gzipBlock) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(gzipBlock);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.decodeBufferSize);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)byteArrayInputStream, this.gzipBufferSize);){
                gzipInputStream.transferTo(byteArrayOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public long getNumBlocksEncoded() {
        return this.numBlocksEncoded.get();
    }

    public GzipBlockStream resetCounters() {
        this.numBlocksEncoded.set(0L);
        return this;
    }

    public static class GzipBlockStreamEncodedBlock {
        private final byte[] gzipBytes;

        private GzipBlockStreamEncodedBlock(byte[] gzipBytes) {
            this.gzipBytes = gzipBytes;
        }

        public void toOutputStream(OutputStream outputStream) {
            VarIntTool.encode(outputStream, this.gzipBytes.length);
            OutputStreamTool.write(outputStream, this.gzipBytes);
        }

        public static InputStream toInputStream(Scanner<GzipBlockStreamEncodedBlock> blocks) {
            return (InputStream)blocks.map(block -> block.gzipBytes).concat(gzipBytes -> Scanner.of((Object[])new byte[][]{VarIntTool.encode(((byte[])gzipBytes).length), gzipBytes})).apply(MultiByteArrayInputStream::new);
        }
    }

    public static final class GzipBlockStreamRow
    extends Record {
        private final List<byte[]> tokens;
        private final int length;

        public GzipBlockStreamRow(List<byte[]> tokens) {
            this(tokens, ByteTool.totalLength(tokens));
        }

        public byte[] concatTokens() {
            return ByteTool.concat(this.tokens);
        }

        public static int totalLength(List<GzipBlockStreamRow> rows) {
            return rows.stream().mapToInt(GzipBlockStreamRow::length).sum();
        }

        public static byte[] concatRows(List<GzipBlockStreamRow> rows) {
            return (byte[])Scanner.of(rows).concatIter(GzipBlockStreamRow::tokens).listTo(ByteTool::concat);
        }

        public List<byte[]> tokens() {
            return this.tokens;
        }

        public int length() {
            return this.length;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{GzipBlockStreamRow.class, "tokens;length", "tokens", "length"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GzipBlockStreamRow.class, "tokens;length", "tokens", "length"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GzipBlockStreamRow.class, "tokens;length", "tokens", "length"}, this, object);
        }

        public GzipBlockStreamRow(List list, int n) {
            this.tokens = list;
            this.length = n;
        }
    }
}

