/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.util.Arrays;

public class TerminatedByteArrayTool {
    public static final byte TERMINAL_BYTE = 0;
    public static final byte ESCAPE_BYTE = 1;
    public static final int ESCAPE_SHIFT = 2;

    public static int escapedAndTerminatedLength(byte[] input) {
        return TerminatedByteArrayTool.escapeAndTerminate(input).length;
    }

    public static byte[] escapeAndTerminate(byte[] input) {
        int numToEscape = TerminatedByteArrayTool.numToEscape(input);
        if (numToEscape == 0) {
            return TerminatedByteArrayTool.terminate(input);
        }
        int escapedLength = input.length + numToEscape;
        int terminatedLength = escapedLength + 1;
        byte[] result = new byte[terminatedLength];
        int inputIndex = 0;
        int escapedIndex = 0;
        while (escapedIndex < escapedLength) {
            byte byteI = input[inputIndex];
            if (TerminatedByteArrayTool.needsEscaping(input[inputIndex])) {
                result[escapedIndex] = 1;
                result[++escapedIndex] = (byte)(byteI + 2);
            } else {
                result[escapedIndex] = input[inputIndex];
            }
            ++inputIndex;
            ++escapedIndex;
        }
        result[result.length - 1] = 0;
        return result;
    }

    private static boolean needsEscaping(byte bite) {
        return bite == 0 || bite == 1;
    }

    private static int numToEscape(byte[] bytes) {
        int numToEscape = 0;
        int i = 0;
        while (i < bytes.length) {
            if (TerminatedByteArrayTool.needsEscaping(bytes[i])) {
                ++numToEscape;
            }
            ++i;
        }
        return numToEscape;
    }

    private static byte[] terminate(byte[] bytes) {
        int terminatedLength = bytes.length + 1;
        byte[] terminatedBytes = new byte[terminatedLength];
        System.arraycopy(bytes, 0, terminatedBytes, 0, bytes.length);
        terminatedBytes[terminatedBytes.length - 1] = 0;
        return terminatedBytes;
    }

    public static int lengthWithTerminator(byte[] bytes, int offset) {
        return TerminatedByteArrayTool.findTerminalIndex(bytes, offset) - offset + 1;
    }

    public static int findTerminalIndex(byte[] bytes, int offset) {
        int index = offset;
        while (bytes[index] != 0) {
            ++index;
        }
        return index;
    }

    public static NumEscapedAndTerminalIndex findEscapedCountAndTerminalIndex(byte[] bytes, int offset) {
        int numEscaped = 0;
        int index = offset;
        while (true) {
            if (bytes[index] == 1) {
                ++numEscaped;
            } else if (bytes[index] == 0) break;
            ++index;
        }
        return new NumEscapedAndTerminalIndex(numEscaped, index);
    }

    public static byte[] unescapeAndUnterminate(byte[] escapedBytes, int offset, int numEscaped, int terminalIndex) {
        if (numEscaped == 0) {
            return Arrays.copyOfRange(escapedBytes, offset, terminalIndex);
        }
        int escapedLength = terminalIndex - offset;
        int unescapedLength = escapedLength - numEscaped;
        byte[] unescapedBytes = new byte[unescapedLength];
        int escapedIndex = offset;
        int unescapedIndex = 0;
        while (escapedIndex < terminalIndex) {
            unescapedBytes[unescapedIndex] = escapedBytes[escapedIndex] == 1 ? (byte)(escapedBytes[++escapedIndex] - 2) : escapedBytes[escapedIndex];
            ++escapedIndex;
            ++unescapedIndex;
        }
        return unescapedBytes;
    }

    public static byte[] unescapeAndUnterminate(byte[] escapedBytes, int offset) {
        NumEscapedAndTerminalIndex numEscapedAndTerminalIndex = TerminatedByteArrayTool.findEscapedCountAndTerminalIndex(escapedBytes, offset);
        return TerminatedByteArrayTool.unescapeAndUnterminate(escapedBytes, offset, numEscapedAndTerminalIndex.numEscaped, numEscapedAndTerminalIndex.terminalIndex);
    }

    public static class NumEscapedAndTerminalIndex {
        public final int numEscaped;
        public final int terminalIndex;

        public NumEscapedAndTerminalIndex(int numEscaped, int terminalIndex) {
            this.numEscaped = numEscaped;
            this.terminalIndex = terminalIndex;
        }
    }
}

