/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.primitivelist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.primitivelist.BasePrimitiveList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Spliterator;

public class PrimitiveIntList
extends BasePrimitiveList<Integer> {
    private static final PrimitiveIntList EMPTY = new PrimitiveIntList(EmptyArray.INT);
    private final int[] array;

    public PrimitiveIntList(int[] array) {
        this(array, 0, array.length);
    }

    public PrimitiveIntList(int[] array, int from, int to) {
        super(from, to);
        this.array = array;
    }

    public PrimitiveIntList(Collection<Integer> values) {
        super(0, values.size());
        this.array = new int[values.size()];
        this.initFromCollection(values);
    }

    public static PrimitiveIntList empty() {
        return EMPTY;
    }

    public Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.array, this.from, this.to);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean internalEquals(Object object) {
        Object object2 = object;
        if (object2 instanceof PrimitiveIntList) {
            void that;
            PrimitiveIntList primitiveIntList = (PrimitiveIntList)object2;
            PrimitiveIntList cfr_ignored_0 = (PrimitiveIntList)object2;
            return Arrays.equals(this.array, this.from, this.to, that.array, that.from, that.to);
        }
        return false;
    }

    @Override
    protected int internalFirstIndexOf(Object obj) {
        long value = ((Integer)obj).intValue();
        int i = this.from;
        while (i < this.to) {
            if ((long)this.array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected Integer internalGet(int index) {
        return this.array[this.from + index];
    }

    @Override
    protected int internalHashCode() {
        int result = 1;
        int i = this.from;
        while (i < this.to) {
            result = 31 * result + Integer.hashCode(this.array[i]);
            ++i;
        }
        return result;
    }

    @Override
    protected boolean internalIsCorrectType(Object object) {
        return object instanceof Integer;
    }

    @Override
    protected int internalLastIndexOf(Object obj) {
        long value = ((Integer)obj).intValue();
        int i = this.to - 1;
        while (i >= this.from) {
            if ((long)this.array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    protected Integer internalSet(int index, Integer value) {
        int oldValue = this.array[index];
        this.array[this.from + index] = value;
        return oldValue;
    }

    @Override
    protected List<Integer> internalSubList(int fromIndex, int toIndex) {
        return new PrimitiveIntList(this.array, this.from + fromIndex, this.from + toIndex);
    }
}

