/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.InputStreamTool;
import io.datarouter.bytes.MultiByteArrayInputStream;
import io.datarouter.bytes.kvfile.KvFileBlock;
import io.datarouter.bytes.kvfile.KvFileEntry;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;

public class KvFileReader {
    private static final int DEFAULT_PARSE_BATCH_SIZE = 3;
    private final InputStream inputStream;
    private final String name;
    private final int parseBatchSize;
    private final Threads parseThreads;

    public KvFileReader(InputStream inputStream, String name, int parseBatchSize, Threads parseThreads) {
        this.inputStream = inputStream;
        this.name = name;
        this.parseBatchSize = parseBatchSize;
        this.parseThreads = parseThreads;
    }

    public KvFileReader(byte[] bytes, String name, int parseBatchSize, Threads parseThreads) {
        this(new ByteArrayInputStream(bytes), name, parseBatchSize, parseThreads);
    }

    public KvFileReader(Scanner<byte[]> chunkScanner, String name, int parseBatchSize, Threads parseThreads) {
        this((InputStream)chunkScanner.apply(MultiByteArrayInputStream::new), name, parseBatchSize, parseThreads);
    }

    public KvFileReader(InputStream inputStream, Threads parseThreads) {
        this(inputStream, null, 3, parseThreads);
    }

    public KvFileReader(InputStream inputStream, String name) {
        this(inputStream, name, 3, null);
    }

    public KvFileReader(InputStream inputStream) {
        this(inputStream, null, 3, null);
    }

    public Scanner<byte[]> scanBlockByteArrays() {
        return Scanner.generate(() -> {
            try {
                byte[] bytes = KvFileBlock.blockBytesFromInputStream(this.inputStream);
                if (bytes == null) {
                    InputStreamTool.close(this.inputStream);
                }
                return bytes;
            }
            catch (RuntimeException e) {
                String message = String.format("error on %s, inputStreamType=%s, name=%s", this.getClass().getSimpleName(), this.inputStream.getClass().getSimpleName(), this.name);
                throw new RuntimeException(message, e);
            }
        }).advanceUntil(Objects::isNull);
    }

    public Scanner<KvFileBlock> scanBlocks() {
        if (this.parseThreads == null) {
            return this.scanBlockByteArrays().map(KvFileBlock::fromBytes);
        }
        return this.scanBlockByteArrays().batch(this.parseBatchSize).parallelOrdered(this.parseThreads).map(byteArrays -> (ArrayList)Scanner.of((Iterable)byteArrays).map(KvFileBlock::fromBytes).collect(() -> new ArrayList(byteArrays.size()))).concat(Scanner::of);
    }

    public Scanner<KvFileEntry> scanBlockEntries() {
        return this.scanBlocks().concat(KvFileBlock::scanEntries);
    }
}

