/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.kvfile.KvFileCollator;
import io.datarouter.bytes.kvfile.KvFileNameAndSize;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvFileCompactorFileCache {
    private static final Logger logger = LoggerFactory.getLogger(KvFileCompactorFileCache.class);
    private final int targetNumFiles;
    private final boolean prune;
    private final ByteLength readBufferSize;
    private final int memoryFanIn;
    private final int streamingFanIn;
    private final Set<KvFileNameAndSize> files;

    public KvFileCompactorFileCache(int targetNumFiles, boolean prune, ByteLength readBufferSize, int memoryFanIn, int streamingFanIn, List<KvFileNameAndSize> files) {
        this.targetNumFiles = targetNumFiles;
        this.prune = prune;
        this.readBufferSize = readBufferSize;
        this.memoryFanIn = memoryFanIn;
        this.streamingFanIn = streamingFanIn;
        this.files = new TreeSet<KvFileNameAndSize>(KvFileNameAndSize.COMPARE_SIZE_AND_NAME);
        this.files.addAll(files);
        if (this.files.size() != files.size()) {
            String message = String.format("%s != %s", this.files.size(), files.size());
            throw new RuntimeException(message);
        }
    }

    public int numFiles() {
        return this.files.size();
    }

    public ByteLength totalSize() {
        return KvFileNameAndSize.totalSize(this.files);
    }

    public void add(KvFileNameAndSize file) {
        this.files.add(file);
    }

    public void remove(KvFileNameAndSize file) {
        this.files.remove(file);
    }

    public boolean hasMoreToMerge() {
        return this.files.size() > this.targetNumFiles;
    }

    private List<KvFileNameAndSize> listFilesToMergeInMemory() {
        int maxFiles = Math.min(this.files.size() - this.targetNumFiles + 1, this.memoryFanIn);
        SizeLimiter sizeLimiter = new SizeLimiter(this.readBufferSize);
        return Scanner.of(this.files).limit((long)maxFiles).advanceWhile(sizeLimiter::fits).each(sizeLimiter::add).list();
    }

    private List<KvFileNameAndSize> listFilesToMergeStreaming() {
        int maxFiles = Math.min(this.files.size() - this.targetNumFiles + 1, this.streamingFanIn);
        return Scanner.of(this.files).limit((long)maxFiles).list();
    }

    public Optional<KvFileMergePlan> findNextMergePlan() {
        if (!this.hasMoreToMerge()) {
            return Optional.empty();
        }
        List<KvFileNameAndSize> toMergeMemory = this.listFilesToMergeInMemory();
        List<KvFileNameAndSize> toMergeStreaming = this.listFilesToMergeStreaming();
        List<KvFileNameAndSize> toMerge = toMergeMemory.size() > toMergeStreaming.size() ? toMergeMemory : toMergeStreaming;
        int numRemainingFiles = this.files.size() - toMerge.size() + 1;
        logger.warn("selecting {}/{}->{} from memory={} or streaming={}", new Object[]{toMerge.size(), this.files.size(), numRemainingFiles, toMergeMemory.size(), toMergeStreaming.size()});
        KvFileCollator.KvFileCollatorStrategy collatorStrategy = KvFileCollator.KvFileCollatorStrategy.KEEP_ALL;
        if (this.prune && numRemainingFiles == 1) {
            collatorStrategy = KvFileCollator.KvFileCollatorStrategy.PRUNE_ALL;
        }
        KvFileMergePlan mergePlan = new KvFileMergePlan(toMerge, collatorStrategy);
        return Optional.of(mergePlan);
    }

    public record KvFileMergePlan(List<KvFileNameAndSize> files, KvFileCollator.KvFileCollatorStrategy collatorStrategy) {
        public ByteLength totalInputSize() {
            return KvFileNameAndSize.totalSize(this.files);
        }
    }

    private static class SizeLimiter {
        ByteLength maxSize;
        AtomicLong currentSize = new AtomicLong();

        SizeLimiter(ByteLength maxSize) {
            this.maxSize = maxSize;
            this.currentSize = new AtomicLong();
        }

        boolean fits(KvFileNameAndSize file) {
            return this.currentSize.get() + file.size() <= this.maxSize.toBytes();
        }

        void add(KvFileNameAndSize file) {
            this.currentSize.addAndGet(file.size());
        }
    }
}

