/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.kvfile.KvFileCompactorFileCache;
import io.datarouter.bytes.kvfile.KvFileMerger;
import io.datarouter.bytes.kvfile.KvFileNameAndSize;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvFileCompactor {
    private static final Logger logger = LoggerFactory.getLogger(KvFileCompactor.class);
    private final KvFileCompactorParams params;
    private final KvFileCompactorFileCache fileCache;

    public KvFileCompactor(KvFileCompactorParams params) {
        this.params = params;
        this.fileCache = new KvFileCompactorFileCache(params.targetNumFiles(), params.prune(), params.mergerParams().byteReaderParams().readBufferSize(), params.mergerParams().byteReaderParams().memoryFanIn(), params.mergerParams().byteReaderParams().streamingFanIn(), this.listFilesInDirectory());
        long writeBufferSizeBytes = params.mergerParams().writeParams().partSize().toBytes() * (long)params.mergerParams().writeParams().writeThreads().count();
        logger.warn("Creating, chunkBufferSize={}, writeParallelBufferSize={}", (Object)params.mergerParams().byteReaderParams().readBufferSize().toDisplay(), (Object)ByteLength.ofBytes(writeBufferSizeBytes).toDisplay());
    }

    public void compact() {
        Scanner.generate(() -> this.fileCache.findNextMergePlan()).advanceWhile(Optional::isPresent).map(Optional::orElseThrow).forEach(this::merge);
    }

    private void merge(KvFileCompactorFileCache.KvFileMergePlan plan) {
        logger.warn("startingMerging {}/{}->{}, inputSize={}, files={}", new Object[]{plan.files().size(), this.fileCache.numFiles(), this.fileCache.numFiles() - plan.files().size() + 1, KvFileNameAndSize.totalSize(plan.files()).toDisplay(), KvFileCompactor.makeFileSummaryMessage(plan.files())});
        KvFileMerger merger = new KvFileMerger(this.params.mergerParams(), plan, ((Supplier<Boolean>)this.params.shouldStop())::get);
        KvFileNameAndSize newFile = merger.merge();
        this.fileCache.add(newFile);
        Scanner.of(plan.files()).each(this.fileCache::remove).map(KvFileNameAndSize::name).batch(this.params.deleteBatchSize).parallelUnordered(this.params.mergerParams().writeParams().writeThreads()).forEach(this.params.mergerParams().storageParams().storage()::deleteMulti);
    }

    private List<KvFileNameAndSize> listFilesInDirectory() {
        return this.params.mergerParams().storageParams().storage().list();
    }

    private void validateFileCacheSize() {
        int numFilesInDirectory = this.listFilesInDirectory().size();
        if (this.fileCache.numFiles() != numFilesInDirectory) {
            String message = String.format("fileCacheSize=%s != filesInDirectory=%s", this.fileCache.numFiles(), numFilesInDirectory);
            throw new IllegalStateException(message);
        }
    }

    private static String makeFileSummaryMessage(List<KvFileNameAndSize> files) {
        return (String)Scanner.of(files).map(file -> String.format("%s[%s]", file.name(), ByteLength.ofBytes(file.size()).toDisplay())).collect(Collectors.joining(", "));
    }

    public record KvFileCompactorParams(Supplier<Boolean> shouldStop, int targetNumFiles, boolean prune, KvFileMerger.KvFileMergerParams mergerParams, int deleteBatchSize) {
    }
}

