/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.kvfile.KvFileEntry;
import io.datarouter.bytes.kvfile.KvFileOp;
import io.datarouter.bytes.kvfile.KvFileReader;
import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.function.Function;

public class KvFileCollator {
    public static Scanner<KvFileEntry> keepAll(List<KvFileReader> readers) {
        return Scanner.of(readers).collateV2(KvFileReader::scanBlockEntries, KvFileEntry::compareKeyVersionOpOptimized);
    }

    public static Scanner<KvFileEntry> pruneVersions(List<KvFileReader> readers) {
        return Scanner.of(readers).collateV2(KvFileReader::scanBlockEntries, KvFileEntry::compareKeyVersionOpOptimized).link(KvFileCollatorPruneVersionsScanner::new);
    }

    public static Scanner<KvFileEntry> pruneAll(List<KvFileReader> readers) {
        return Scanner.of(readers).collateV2(KvFileReader::scanBlockEntries, KvFileEntry::compareKeyVersionOpOptimized).link(KvFileCollatorPruneDeletesScanner::new);
    }

    public static class KvFileCollatorPruneDeletesScanner
    extends BaseLinkedScanner<KvFileEntry, KvFileEntry> {
        private KvFileEntry peeked;

        public KvFileCollatorPruneDeletesScanner(Scanner<KvFileEntry> input) {
            super(input);
        }

        public boolean advanceInternal() {
            this.current = this.peeked;
            this.peeked = null;
            if (this.current == null && this.input.advance()) {
                this.current = (KvFileEntry)this.input.current();
            }
            while (this.input.advance()) {
                if (KvFileEntry.equalsKeyOptimized((KvFileEntry)this.current, (KvFileEntry)this.input.current())) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                if (((KvFileEntry)this.current).op() == KvFileOp.DELETE) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                this.peeked = (KvFileEntry)this.input.current();
                return true;
            }
            return this.current != null && ((KvFileEntry)this.current).op() != KvFileOp.DELETE;
        }
    }

    public static class KvFileCollatorPruneVersionsScanner
    extends BaseLinkedScanner<KvFileEntry, KvFileEntry> {
        private KvFileEntry peeked;

        public KvFileCollatorPruneVersionsScanner(Scanner<KvFileEntry> input) {
            super(input);
        }

        public boolean advanceInternal() {
            this.current = this.peeked;
            this.peeked = null;
            if (this.current == null && this.input.advance()) {
                this.current = (KvFileEntry)this.input.current();
            }
            while (this.input.advance()) {
                if (KvFileEntry.equalsKeyOptimized((KvFileEntry)this.current, (KvFileEntry)this.input.current())) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                this.peeked = (KvFileEntry)this.input.current();
                return true;
            }
            return this.current != null;
        }
    }

    public static enum KvFileCollatorStrategy {
        KEEP_ALL(KvFileCollator::keepAll),
        PRUNE_VERSIONS(KvFileCollator::pruneVersions),
        PRUNE_ALL(KvFileCollator::pruneAll);

        public final Function<List<KvFileReader>, Scanner<KvFileEntry>> method;

        private KvFileCollatorStrategy(Function<List<KvFileReader>, Scanner<KvFileEntry>> method) {
            this.method = method;
        }
    }
}

