/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.MultiByteArrayInputStream;
import io.datarouter.bytes.kvfile.KvFileBlock;
import io.datarouter.bytes.kvfile.KvFileEntry;
import io.datarouter.bytes.kvfile.KvFileReader;
import io.datarouter.scanner.Scanner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KvFileCodec<T> {
    private static final ByteLength DEFAULT_BLOCK_SIZE = ByteLength.ofKiB(64L);
    public final Codec<T, KvFileEntry> codec;
    public final ByteLength blockSize;

    public KvFileCodec(Codec<T, KvFileEntry> codec, ByteLength blockSize) {
        this.codec = codec;
        this.blockSize = blockSize;
    }

    public KvFileCodec(Codec<T, KvFileEntry> codec) {
        this(codec, DEFAULT_BLOCK_SIZE);
    }

    public Scanner<byte[]> toByteArrays(Scanner<T> items) {
        return items.map(this.codec::encode).batchByMinSize(this.blockSize.toBytes(), KvFileEntry::length).map(KvFileBlock::new).map(KvFileBlock::toBytes);
    }

    public byte[] toByteArray(Collection<T> items) {
        return (byte[])((Scanner)Scanner.of(items).apply(this::toByteArrays)).listTo(ByteTool::concat);
    }

    public InputStream toInputStream(Scanner<T> items) {
        return (InputStream)this.toByteArrays(items).apply(MultiByteArrayInputStream::new);
    }

    public T decode(KvFileEntry entry) {
        return this.codec.decode(entry);
    }

    public Scanner<T> decodeMulti(byte[] bytes) {
        return this.decodeMulti(new ByteArrayInputStream(bytes));
    }

    public Scanner<T> decodeMulti(InputStream inputStream) {
        return new KvFileReader(inputStream).scanBlockEntries().map(this.codec::decode);
    }

    public Scanner<T> decodeBlockToScanner(KvFileBlock block) {
        return block.scanEntries().map(this.codec::decode);
    }

    public List<T> decodeBlockToList(KvFileBlock block) {
        return (List)this.decodeBlockToScanner(block).collect(() -> new ArrayList(block.entries().size()));
    }

    public List<List<T>> decodeBlocksToLists(List<KvFileBlock> blocks) {
        return (List)Scanner.of(blocks).map(this::decodeBlockToList).collect(() -> new ArrayList(blocks.size()));
    }
}

