/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile;

import io.datarouter.bytes.InputStreamTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.kvfile.KvFileEntry;
import io.datarouter.bytes.kvfile.KvFileEntrySerializer;
import io.datarouter.scanner.Scanner;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public record KvFileBlock(List<KvFileEntry> entries) {
    public int headerLength() {
        int total = 0;
        return total += VarIntTool.length(this.entries.size());
    }

    public int dataLength() {
        return this.entries.stream().mapToInt(KvFileEntry::length).sum();
    }

    public int length() {
        return this.headerLength() + this.dataLength();
    }

    public Scanner<KvFileEntry> scanEntries() {
        return Scanner.of(this.entries);
    }

    public byte[] toBytes() {
        int numBlockBytes = this.length();
        int numLengthPrefixBytes = VarIntTool.length(numBlockBytes);
        int bytes = numLengthPrefixBytes + numBlockBytes;
        byte[] blockBytes = new byte[bytes];
        VarIntTool.encode(blockBytes, 0, numBlockBytes);
        this.bodyToBytes(blockBytes, numLengthPrefixBytes);
        return blockBytes;
    }

    private void bodyToBytes(byte[] bytes, int offset) {
        int cursor = offset;
        cursor += VarIntTool.encode(bytes, cursor, this.entries.size());
        for (KvFileEntry entry : this.entries) {
            System.arraycopy(entry.backingBytes(), entry.offset(), bytes, cursor, entry.length());
            cursor += entry.length();
        }
    }

    public static KvFileBlock fromBytes(byte[] bytes) {
        int cursor = 0;
        int size = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(size);
        ArrayList<KvFileEntry> entries = new ArrayList<KvFileEntry>(size);
        int i = 0;
        while (i < size) {
            KvFileEntry entry = KvFileEntrySerializer.fromBytes(bytes, cursor);
            cursor += entry.length();
            entries.add(entry);
            ++i;
        }
        return new KvFileBlock(entries);
    }

    public static byte[] blockBytesFromInputStream(InputStream inputStream) {
        Integer numDataBytes = VarIntTool.decodeIntOrNull(inputStream);
        return numDataBytes == null ? null : InputStreamTool.readNBytes(inputStream, numDataBytes);
    }
}

