/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;

public class VarIntTool {
    public static final String ERROR_MESSAGE_INVALID_OFFSET = "InvalidOffset";
    public static final String ERROR_MESSAGE_INCOMPLETE_VALUE = "Incomplete value";
    public static final String ERROR_MESSAGE_INTEGER_OVERFLOW = "Integer overflow";
    public static final String ERROR_MESSAGE_IO = "IO Error";
    public static final String ERROR_MESSAGE_MAX_SIZE_EXCEEDED = "Max size exceeded";
    public static final String ERROR_MESSAGE_NEGATIVE_VALUE = "Cannot be negative";
    public static final String ERROR_MESSAGE_UNEXPECTED_END_OF_INPUT_STREAM = "Unexpected end of InputStream";
    public static final byte[] INTEGER_MAX_ENCODED_VALUE = new byte[]{-1, -1, -1, -1, 7};
    public static final byte[] LONG_MAX_ENCODED_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
    private static final byte BYTE_7_RIGHT_BITS_SET = 127;
    private static final long LONG_7_RIGHT_BITS_SET = 127L;
    private static final long LONG_8TH_BIT_SET = 128L;
    private static final int MAX_LENGTH = 9;

    private static void validate(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(ERROR_MESSAGE_NEGATIVE_VALUE);
        }
    }

    public static int length(long value) {
        VarIntTool.validate(value);
        if (value == 0L) {
            return 1;
        }
        return (70 - Long.numberOfLeadingZeros(value)) / 7;
    }

    public static byte[] encode(long value) {
        int length = VarIntTool.length(value);
        byte[] bytes = new byte[length];
        VarIntTool.encode(bytes, 0, value);
        return bytes;
    }

    public static int encode(byte[] bytes, int offset, long value) {
        VarIntTool.validate(value);
        int length = VarIntTool.length(value);
        long remainder = value;
        int cursor = offset;
        int i = 0;
        while (i < length - 1) {
            bytes[cursor] = (byte)(remainder & 0x7FL | 0x80L);
            ++cursor;
            remainder >>= 7;
            ++i;
        }
        bytes[cursor] = (byte)(remainder & 0x7FL);
        ++cursor;
        return length;
    }

    public static int encode(OutputStream outputStream, long value) {
        VarIntTool.validate(value);
        int length = VarIntTool.length(value);
        long remainder = value;
        try {
            int i = 0;
            while (i < length - 1) {
                byte bite = (byte)(remainder & 0x7FL | 0x80L);
                outputStream.write(bite);
                remainder >>= 7;
                ++i;
            }
            byte bite = (byte)(remainder & 0x7FL);
            outputStream.write(bite);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ERROR_MESSAGE_IO, e);
        }
        return length;
    }

    @Deprecated
    public static void writeBytes(long value, OutputStream os) {
        VarIntTool.encode(os, value);
    }

    public static long decodeLong(byte[] bytes, int offset) {
        if (offset >= bytes.length) {
            throw new IllegalArgumentException(ERROR_MESSAGE_INVALID_OFFSET);
        }
        long value = 0L;
        int i = 0;
        while (true) {
            if (i == 9) {
                throw new IllegalArgumentException(ERROR_MESSAGE_MAX_SIZE_EXCEEDED);
            }
            byte byteVar = bytes[i + offset];
            long shifted = 0x7F & byteVar;
            value |= (shifted <<= 7 * i);
            if (byteVar >= 0) break;
            ++i;
        }
        return value;
    }

    public static long decodeLong(byte[] bytes) {
        return VarIntTool.decodeLong(bytes, 0);
    }

    public static long decodeLong(InputStream inputStream) {
        return VarIntTool.decodeLongInternal(inputStream);
    }

    public static Long decodeLongOrNull(InputStream inputStream) {
        try {
            return VarIntTool.decodeLongInternal(inputStream);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static long decodeLongInternal(InputStream inputStream) {
        long value = 0L;
        try {
            int i = 0;
            while (true) {
                if (i == 9) {
                    throw new IllegalArgumentException(ERROR_MESSAGE_MAX_SIZE_EXCEEDED);
                }
                int byteInt = inputStream.read();
                if (byteInt == -1) {
                    throw new IllegalArgumentException(ERROR_MESSAGE_UNEXPECTED_END_OF_INPUT_STREAM);
                }
                byte bite = (byte)byteInt;
                long shifted = 0x7F & bite;
                value |= (shifted <<= 7 * i);
                if (bite < 0) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(ERROR_MESSAGE_IO, e);
        }
        return value;
    }

    public static Optional<Long> fromInputStream(InputStream is) {
        return VarIntTool.nextBytes(is).map(VarIntTool::decodeLong);
    }

    public static Optional<Integer> fromInputStreamInt(InputStream is) {
        return VarIntTool.nextBytes(is).map(VarIntTool::decodeInt);
    }

    private static Optional<byte[]> nextBytes(InputStream is) {
        byte[] buffer = new byte[9];
        int cursor = 0;
        boolean foundFirstByte = false;
        try {
            int byteVar;
            do {
                if (cursor == 9) {
                    throw new IllegalArgumentException(ERROR_MESSAGE_MAX_SIZE_EXCEEDED);
                }
                byteVar = is.read();
                if (byteVar == -1) {
                    if (foundFirstByte) {
                        throw new IllegalArgumentException(ERROR_MESSAGE_INCOMPLETE_VALUE);
                    }
                    return Optional.empty();
                }
                buffer[cursor] = (byte)byteVar;
                ++cursor;
                foundFirstByte = true;
            } while (byteVar >= 128);
        }
        catch (IOException e) {
            throw new UncheckedIOException(ERROR_MESSAGE_IO, e);
        }
        return Optional.of(buffer);
    }

    public static int decodeInt(byte[] bytes, int offset) {
        return VarIntTool.downcastToInt(VarIntTool.decodeLong(bytes, offset));
    }

    public static int decodeInt(byte[] bytes) {
        return VarIntTool.downcastToInt(VarIntTool.decodeLong(bytes, 0));
    }

    public static int decodeInt(InputStream inputStream) {
        return VarIntTool.downcastToInt(VarIntTool.decodeLongInternal(inputStream));
    }

    public static Integer decodeIntOrNull(InputStream inputStream) {
        Long value = VarIntTool.decodeLongOrNull(inputStream);
        return value == null ? null : Integer.valueOf(Math.toIntExact(value));
    }

    private static int downcastToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ERROR_MESSAGE_INTEGER_OVERFLOW);
        }
        return (int)value;
    }
}

