/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import java.util.Arrays;
import java.util.List;

public class VarIntByteArraysTool {
    public static int encodedLength(List<byte[]> arrays) {
        int encodedLength = 0;
        for (byte[] array : arrays) {
            encodedLength += VarIntTool.length(array.length);
            encodedLength += array.length;
        }
        return encodedLength;
    }

    public static byte[] encodeOne(byte[] input) {
        int dataLength = input.length;
        int headerLength = VarIntTool.length(dataLength);
        int outputLength = headerLength + dataLength;
        byte[] output = new byte[outputLength];
        VarIntTool.encode(output, 0, dataLength);
        System.arraycopy(input, 0, output, headerLength, dataLength);
        return output;
    }

    public static byte[] encodeMulti(Scanner<byte[]> arrays) {
        return (byte[])arrays.map(VarIntByteArraysTool::encodeOne).listTo(ByteTool::concat);
    }

    public static byte[] decodeOne(byte[] encodedBytes) {
        return VarIntByteArraysTool.decodeOne(encodedBytes, 0);
    }

    public static byte[] decodeOne(byte[] encodedBytes, int offset) {
        int cursor = offset;
        int length = VarIntTool.decodeInt(encodedBytes, cursor);
        return Arrays.copyOfRange(encodedBytes, cursor += VarIntTool.length(length), cursor + length);
    }

    public static Scanner<byte[]> decodeMulti(byte[] block) {
        return new VarIntByteArraysScanner(block);
    }

    private static class VarIntByteArraysScanner
    extends BaseScanner<byte[]> {
        private final byte[] block;
        private int cursor;

        public VarIntByteArraysScanner(byte[] block) {
            this.block = block;
            this.cursor = 0;
        }

        public boolean advance() {
            if (this.cursor == this.block.length) {
                return false;
            }
            int length = VarIntTool.decodeInt(this.block, this.cursor);
            this.cursor += VarIntTool.length(length);
            this.current = Arrays.copyOfRange(this.block, this.cursor, this.cursor + length);
            this.cursor += length;
            return true;
        }
    }
}

