/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class CountingOutputStream
extends FilterOutputStream {
    private final long countInterval;
    private final Consumer<Long> countCallback;
    private long count;
    private long countSinceLastPublished;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.countInterval = 0L;
        this.countCallback = null;
    }

    public CountingOutputStream(OutputStream outputStream, int countInterval, Consumer<Long> countCallback) {
        super(outputStream);
        this.countInterval = countInterval;
        this.countCallback = countCallback;
    }

    @Override
    public void write(int byteData) throws IOException {
        this.out.write(byteData);
        ++this.count;
        this.updateCountSinceLastPublished(1L);
    }

    @Override
    public void write(byte[] byteData, int offset, int length) throws IOException {
        this.out.write(byteData, offset, length);
        this.count += (long)length;
        this.updateCountSinceLastPublished(length);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.countCallback != null) {
            this.countCallback.accept(this.countSinceLastPublished);
            this.countSinceLastPublished = 0L;
        }
    }

    private void updateCountSinceLastPublished(long byteCount) {
        this.countSinceLastPublished += byteCount;
        if (this.countCallback != null && this.countSinceLastPublished >= this.countInterval) {
            this.countCallback.accept(this.countSinceLastPublished);
            this.countSinceLastPublished = 0L;
        }
    }

    public long getCount() {
        return this.count;
    }
}

