/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class CountingInputStream
extends FilterInputStream {
    private final long countInterval;
    private final Consumer<Long> countCallback;
    private long count;
    private long countSinceLastPublished;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
        this.countInterval = 0L;
        this.countCallback = null;
    }

    public CountingInputStream(InputStream inputStream, int countInterval, Consumer<Long> countCallback) {
        super(inputStream);
        this.countSinceLastPublished = 0L;
        this.countInterval = countInterval;
        this.countCallback = countCallback;
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            ++this.count;
            this.updateCountSinceLastPublished(1L);
        }
        return data;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int byteCount = super.read(buffer, offset, length);
        if (byteCount != -1) {
            this.count += (long)byteCount;
            this.updateCountSinceLastPublished(byteCount);
        }
        return byteCount;
    }

    @Override
    public long skip(long skipBytes) throws IOException {
        long skipCount = super.skip(skipBytes);
        this.count += skipCount;
        this.updateCountSinceLastPublished(skipCount);
        return skipCount;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.countCallback != null) {
            this.countCallback.accept(this.countSinceLastPublished);
            this.countSinceLastPublished = 0L;
        }
    }

    private void updateCountSinceLastPublished(long byteCount) {
        this.countSinceLastPublished += byteCount;
        if (this.countCallback != null && this.countSinceLastPublished >= this.countInterval) {
            this.countCallback.accept(this.countSinceLastPublished);
            this.countSinceLastPublished = 0L;
        }
    }

    public long getCount() {
        return this.count;
    }
}

