/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.OutputStreamTool;
import io.datarouter.bytes.codec.bytestringcodec.CsvIntByteStringCodec;
import java.io.OutputStream;
import java.util.Arrays;

public class Bytes
implements Comparable<Bytes> {
    public static final Bytes EMPTY = new Bytes(EmptyArray.BYTE);
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public Bytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Bytes(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] toArray() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }

    public void toOutputStream(OutputStream outputStream) {
        OutputStreamTool.write(outputStream, this.bytes, this.offset, this.length);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Bytes)) {
            return false;
        }
        Bytes that = (Bytes)thatObject;
        int thisTo = this.offset + this.length;
        int otherTo = that.offset + that.length;
        return Arrays.equals(this.bytes, this.offset, thisTo, that.bytes, that.offset, otherTo);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.length) {
            result = 31 * result + this.bytes[this.offset + i];
            ++i;
        }
        return result;
    }

    @Override
    public int compareTo(Bytes other) {
        int thisTo = this.offset + this.length;
        int otherTo = other.offset + other.length;
        return Arrays.compareUnsigned(this.bytes, this.offset, thisTo, other.bytes, other.offset, otherTo);
    }

    public String toString() {
        return "[" + CsvIntByteStringCodec.INSTANCE.encode(this.toArray()) + "]";
    }
}

