/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public class ByteLength {
    public static final ByteLength MIN = ByteLength.ofBytes(0L);
    public static final ByteLength MAX = ByteLength.ofBytes(Long.MAX_VALUE);
    private static final Unit[] BIN_SORTED_ASC = new Unit[]{Unit.B, Unit.KiB, Unit.MiB, Unit.GiB, Unit.TiB, Unit.PiB};
    private static final Unit[] DEC_SORTED_ASC = new Unit[]{Unit.B, Unit.KB, Unit.MB, Unit.GB, Unit.TB, Unit.PB};
    private final long length;

    private ByteLength(long length) {
        this.length = length;
    }

    public long toBytes() {
        return this.length;
    }

    public int toBytesInt() {
        return Math.toIntExact(this.length);
    }

    public double toBytesDouble() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteLength other = (ByteLength)obj;
        return this.length == other.length;
    }

    public String toString() {
        return Long.toString(this.length);
    }

    public String toDisplay() {
        return this.toDisplay(ByteUnitSystem.BINARY);
    }

    public String toDisplay(ByteUnitSystem byteUnitSystem) {
        Objects.requireNonNull(byteUnitSystem);
        Long step = byteUnitSystem.step;
        Unit[] unitArray = ByteLength.getAscValues(byteUnitSystem);
        int n = unitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Unit unit = unitArray[n2];
            if (step.compareTo(Math.abs(this.length / unit.unitValue)) > 0) {
                return this.getNumBytesDisplay(unit);
            }
            ++n2;
        }
        if (ByteUnitSystem.BINARY == byteUnitSystem) {
            return this.getNumBytesDisplay(Unit.PiB);
        }
        return this.getNumBytesDisplay(Unit.PB);
    }

    private String getNumBytesDisplay(Unit byteUnit) {
        double numBytes = (double)this.length / (double)byteUnit.unitValue;
        BigDecimal bigDecimal = new BigDecimal(numBytes).round(new MathContext(3));
        return String.valueOf(bigDecimal.toPlainString()) + " " + (Object)((Object)byteUnit);
    }

    public static Unit[] getAscValues(ByteUnitSystem byteUnitSystem) {
        if (ByteUnitSystem.DECIMAL == byteUnitSystem) {
            return DEC_SORTED_ASC;
        }
        return BIN_SORTED_ASC;
    }

    public static ByteLength ofBytes(long input) {
        return ByteLength.of(input, Unit.B);
    }

    public static ByteLength ofKB(long input) {
        return ByteLength.of(input, Unit.KB);
    }

    public static ByteLength ofMB(long input) {
        return ByteLength.of(input, Unit.MB);
    }

    public static ByteLength ofGB(long input) {
        return ByteLength.of(input, Unit.GB);
    }

    public static ByteLength ofTB(long input) {
        return ByteLength.of(input, Unit.TB);
    }

    public static ByteLength ofPB(long input) {
        return ByteLength.of(input, Unit.PB);
    }

    public static ByteLength ofKiB(long input) {
        return ByteLength.of(input, Unit.KiB);
    }

    public static ByteLength ofMiB(long input) {
        return ByteLength.of(input, Unit.MiB);
    }

    public static ByteLength ofGiB(long input) {
        return ByteLength.of(input, Unit.GiB);
    }

    public static ByteLength ofTiB(long input) {
        return ByteLength.of(input, Unit.TiB);
    }

    public static ByteLength ofPiB(long input) {
        return ByteLength.of(input, Unit.PiB);
    }

    private static ByteLength of(long input, Unit unit) {
        return new ByteLength(input * unit.unitValue);
    }

    public long toKB() {
        return this.to(Unit.KB);
    }

    public long toMB() {
        return this.to(Unit.MB);
    }

    public long toGB() {
        return this.to(Unit.GB);
    }

    public long toTB() {
        return this.to(Unit.TB);
    }

    public long toPB() {
        return this.to(Unit.PB);
    }

    public long toKiB() {
        return this.to(Unit.KiB);
    }

    public long toMiB() {
        return this.to(Unit.MiB);
    }

    public long toGiB() {
        return this.to(Unit.GiB);
    }

    public long toTiB() {
        return this.to(Unit.TiB);
    }

    public long toPiB() {
        return this.to(Unit.PiB);
    }

    private long to(Unit unit) {
        return this.length / unit.unitValue;
    }

    public static enum ByteUnitSystem {
        DECIMAL(1000L),
        BINARY(1024L);

        public final long step;

        private ByteUnitSystem(long step) {
            this.step = step;
        }
    }

    public static enum Unit {
        B(1L),
        KB(1000L),
        MB(Unit.KB.unitValue * 1000L),
        GB(Unit.MB.unitValue * 1000L),
        TB(Unit.GB.unitValue * 1000L),
        PB(Unit.TB.unitValue * 1000L),
        KiB(1024L),
        MiB(Unit.KiB.unitValue * 1024L),
        GiB(Unit.MiB.unitValue * 1024L),
        TiB(Unit.GiB.unitValue * 1024L),
        PiB(Unit.TiB.unitValue * 1024L);

        public final long unitValue;

        private Unit(long unitValue) {
            this.unitValue = unitValue;
        }
    }
}

