/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;

public class BatchingByteArrayScanner
extends BaseLinkedScanner<byte[], List<byte[]>> {
    private final int maxOutputBytes;
    private byte[] storage;

    public BatchingByteArrayScanner(Scanner<byte[]> input, int maxOutputBytes) {
        super(input);
        this.maxOutputBytes = maxOutputBytes;
        this.storage = null;
    }

    public boolean advanceInternal() {
        List bytesList;
        this.current = new ArrayList();
        int size = 0;
        if (this.storage != null) {
            ((List)this.current).add(this.storage);
            size = this.storage.length;
            this.storage = null;
        }
        while (!(bytesList = this.input.take(1)).isEmpty()) {
            byte[] bytes = (byte[])bytesList.get(0);
            if (bytes.length > this.maxOutputBytes) {
                throw new IllegalArgumentException("encountered oversized input with size=" + size + " and maxOutputBytes=" + this.maxOutputBytes);
            }
            int resultSize = bytes.length + size;
            if (resultSize > this.maxOutputBytes || resultSize < bytes.length) {
                this.storage = bytes;
                break;
            }
            ((List)this.current).add(bytes);
            size += bytes.length;
        }
        return size > 0;
    }
}

