/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.binarydto.dto.BaseBinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class BinaryDtoMetadataParser<T extends BaseBinaryDto<T>> {
    private final T dto;

    public BinaryDtoMetadataParser(T dto) {
        this.dto = dto;
    }

    public List<Field> listFields() {
        return this.anyIndexSpecified() ? this.listFieldsByIndex() : this.listFieldsAlphabetically();
    }

    private List<Field> listFieldsByIndex() {
        Field[] fields = new Field[this.maxFieldIndex() + 1];
        this.scanFields().map(BinaryDtoFieldMetadataParser::new).forEach(metadata -> {
            int index = metadata.getRequiredIndex();
            if (index < 0) {
                String message = String.format("index=%s cannot be negative", index);
                throw new IllegalArgumentException(message);
            }
            if (fields[index] != null) {
                String message = String.format("index=%s already specified", index);
                throw new IllegalArgumentException(message);
            }
            fieldArray[index] = metadata.getField();
        });
        return Arrays.asList(fields);
    }

    private List<Field> listFieldsAlphabetically() {
        return this.scanFields().each(field -> {
            if (new BinaryDtoFieldMetadataParser((Field)field).hasIndex()) {
                String message = String.format("Classes extending %s cannot have BinaryDtoField index specified.  Field=%s", this.getClass().getCanonicalName(), field.getName());
                throw new IllegalArgumentException(message);
            }
        }).sort(Comparator.comparing(Field::getName)).list();
    }

    private Scanner<Field> scanFields() {
        return BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(this.dto.getClass());
    }

    private boolean anyIndexSpecified() {
        return this.scanFields().map(BinaryDtoFieldMetadataParser::new).anyMatch(BinaryDtoFieldMetadataParser::hasIndex);
    }

    private int maxFieldIndex() {
        return (Integer)this.scanFields().map(BinaryDtoFieldMetadataParser::new).map(BinaryDtoFieldMetadataParser::getRequiredIndex).findMax(Comparator.naturalOrder()).orElseThrow();
    }
}

