/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.binarydto.dto.BinaryDtoField;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;

public class BinaryDtoFieldMetadataParser<T> {
    public final Field field;

    public BinaryDtoFieldMetadataParser(Field field) {
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean hasIndex() {
        return this.optIndex().isPresent();
    }

    public Optional<Integer> optIndex() {
        BinaryDtoField annotation = this.field.getAnnotation(BinaryDtoField.class);
        if (annotation == null) {
            return Optional.empty();
        }
        int index = annotation.index();
        if (index == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        return Optional.of(annotation.index());
    }

    public int getRequiredIndex() {
        return this.optIndex().orElseThrow(() -> {
            String message = String.format("Field %s is missing index annotation", this.field.getName());
            throw new IllegalArgumentException(message);
        });
    }

    public boolean isNullable() {
        BinaryDtoField annotation = this.field.getAnnotation(BinaryDtoField.class);
        if (this.field.getType().isPrimitive()) {
            return false;
        }
        if (annotation == null) {
            return true;
        }
        return annotation.nullable();
    }

    public boolean isNullableItems() {
        BinaryDtoField annotation = this.field.getAnnotation(BinaryDtoField.class);
        if (annotation == null) {
            return true;
        }
        return annotation.nullableItems();
    }

    public boolean isPrimitive() {
        return this.field.getType().isPrimitive();
    }

    public boolean isList() {
        return this.field.getType() == List.class;
    }

    public boolean isArray() {
        return this.field.getType().isArray();
    }

    public boolean isPrimitiveArray() {
        return this.isArray() && this.field.getType().getComponentType().isPrimitive();
    }

    public boolean isObjectArray() {
        return this.isArray() && !this.isPrimitiveArray();
    }

    public boolean isEnum() {
        return Enum.class.isAssignableFrom(this.field.getType());
    }

    public Class<?> getObjectArrayItemClass() {
        return this.field.getType().getComponentType();
    }

    public <I> Class<I> getListItemClass() {
        ParameterizedType parameterizedType = (ParameterizedType)this.field.getGenericType();
        Type type = parameterizedType.getActualTypeArguments()[0];
        try {
            return Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<BinaryDtoBaseFieldCodec<?>> optCodec() {
        return this.optCodecClass().map(BinaryDtoReflectionTool::newInstanceUnchecked);
    }

    private Optional<Class<? extends BinaryDtoBaseFieldCodec<?>>> optCodecClass() {
        BinaryDtoField annotation = this.field.getAnnotation(BinaryDtoField.class);
        if (annotation == null) {
            return Optional.empty();
        }
        return annotation.codec() == BinaryDtoField.BinaryDtoInvalidCodec.class ? Optional.empty() : Optional.of(annotation.codec());
    }
}

