/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.other;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseArrayBinaryDtoFieldCodec<T, A>
extends BinaryDtoBaseFieldCodec<A> {
    private final BinaryDtoBaseFieldCodec<T> itemCodec;
    private final boolean isNullableItems;

    public BaseArrayBinaryDtoFieldCodec(BinaryDtoBaseFieldCodec<T> itemCodec, boolean isNullableItems) {
        this.itemCodec = itemCodec;
        this.isNullableItems = isNullableItems;
    }

    @Override
    public boolean supportsComparableCodec() {
        return false;
    }

    public byte[] encodeInternal(List<T> value) {
        int size = value.size();
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(1 + 2 * size);
        byte[] sizeBytes = VarIntTool.encode(size);
        byteArrays.add(sizeBytes);
        for (T item : value) {
            byte[] itemBytes;
            if (this.isNullableItems) {
                if (item == null) {
                    byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY);
                    continue;
                }
                byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY);
                itemBytes = this.itemCodec.encode(item);
                if (this.itemCodec.isVariableLength()) {
                    byteArrays.add(VarIntTool.encode(itemBytes.length));
                }
                byteArrays.add(itemBytes);
                continue;
            }
            if (item == null) {
                throw new IllegalArgumentException("Cannot contain nulls");
            }
            itemBytes = this.itemCodec.encode(item);
            if (this.itemCodec.isVariableLength()) {
                byteArrays.add(VarIntTool.encode(itemBytes.length));
            }
            byteArrays.add(itemBytes);
        }
        return ByteTool.concat(byteArrays);
    }

    public List<T> decodeInternal(byte[] bytes, int offset, int length) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(size);
        ArrayList<Object> value = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object item = null;
            if (this.isNullableItems) {
                boolean isItemNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
                if (!isItemNull) {
                    if (this.itemCodec.isFixedLength()) {
                        item = this.itemCodec.decode(bytes, cursor, this.itemCodec.fixedLength());
                        cursor += this.itemCodec.fixedLength();
                    } else {
                        int itemLength = VarIntTool.decodeInt(bytes, cursor);
                        item = this.itemCodec.decode(bytes, cursor += VarIntTool.length(itemLength), itemLength);
                        cursor += itemLength;
                    }
                }
            } else if (this.itemCodec.isFixedLength()) {
                item = this.itemCodec.decode(bytes, cursor, this.itemCodec.fixedLength());
                cursor += this.itemCodec.fixedLength();
            } else {
                int itemLength = VarIntTool.decodeInt(bytes, cursor);
                item = this.itemCodec.decode(bytes, cursor += VarIntTool.length(itemLength), itemLength);
                cursor += itemLength;
            }
            value.add(item);
            ++i;
        }
        int foundLength = cursor - offset;
        if (length != foundLength) {
            String message = String.format("length mismatch, expectedLength=%s, foundLength=%s", length, foundLength);
            throw new IllegalStateException(message);
        }
        return value;
    }
}

