/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.dto;

import io.datarouter.bytes.binarydto.codec.BinaryDtoComparableCodec;
import io.datarouter.bytes.binarydto.dto.BaseBinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

public abstract class ComparableBinaryDto<T extends ComparableBinaryDto<T>>
extends BaseBinaryDto<T>
implements Comparable<T> {
    private final BinaryDtoComparableCodec<T> comparableCodec() {
        return BinaryDtoComparableCodec.of(this.getClass());
    }

    public final byte[] encodeComparable() {
        return this.comparableCodec().encode(this);
    }

    public final T cloneComparable() {
        return this.comparableCodec().decode(this.encodeComparable());
    }

    @Override
    public final List<Field> getFieldsOrdered() {
        return this.comparableCodec().getFieldsOrdered();
    }

    @Override
    public final int compareTo(T that) {
        Objects.requireNonNull(that);
        if (!this.getClass().equals(that.getClass())) {
            String message = String.format("Cannot compare %s to %s", this.getClass().getCanonicalName(), that.getClass().getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        BinaryDtoComparableCodec<T> codec = this.comparableCodec();
        for (BinaryDtoFieldSchema<?> fieldSchema : codec.fieldSchemas) {
            int fieldDiff = fieldSchema.compareFieldValuesAsIfEncoded(this, that);
            if (fieldDiff == 0) continue;
            return fieldDiff;
        }
        return 0;
    }
}

