/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.dto.BaseBinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoAllocator;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import io.datarouter.bytes.binarydto.internal.BinaryDtoMetadataParser;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryDtoIndexedCodec<T extends BaseBinaryDto<T>>
implements Codec<T, byte[]> {
    private static final Map<Class<? extends BaseBinaryDto<?>>, BinaryDtoIndexedCodec<?>> CACHE = new ConcurrentHashMap();
    private static final int TOKENS_PER_FIELD = 3;
    public final Class<T> dtoClass;
    public final List<Field> fields;
    public final List<? extends BinaryDtoFieldSchema<?>> fieldSchemas;

    private BinaryDtoIndexedCodec(Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        T dto = BinaryDtoAllocator.allocate(dtoClass);
        BinaryDtoMetadataParser<T> metadataParser = new BinaryDtoMetadataParser<T>(dto);
        this.fields = metadataParser.listFields();
        this.fieldSchemas = Scanner.of(this.fields).map(field -> {
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            BinaryDtoFieldSchema fieldSchema = new BinaryDtoFieldSchema((Field)field);
            return fieldSchema;
        }).list();
    }

    public static <T extends BaseBinaryDto<T>> BinaryDtoIndexedCodec<T> of(Class<? extends T> dtoClass) {
        BinaryDtoIndexedCodec<Object> codec = CACHE.get(dtoClass);
        if (codec == null) {
            codec = new BinaryDtoIndexedCodec<T>(dtoClass);
            CACHE.put(dtoClass, codec);
        }
        return codec;
    }

    public List<Field> getFieldsOrdered() {
        return this.fields;
    }

    @Override
    public byte[] encode(T dto) {
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(3 * this.fieldSchemas.size());
        int i = 0;
        while (i < this.fieldSchemas.size()) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(i);
            if (fieldSchema != null) {
                if (fieldSchema.isNull(dto)) {
                    if (!fieldSchema.isNullable()) {
                        String message = String.format("field=%s of class=%s can't contain nulls", fieldSchema.getName(), dto.getClass().getCanonicalName());
                        throw new IllegalArgumentException(message);
                    }
                } else {
                    byte[] fieldBytes = fieldSchema.encodeIndexed(dto);
                    tokens.add(VarIntTool.encode(i));
                    tokens.add(VarIntTool.encode(fieldBytes.length));
                    tokens.add(fieldBytes);
                }
            }
            ++i;
        }
        return ByteTool.concat(tokens);
    }

    @Override
    public T decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public T decode(byte[] bytes, int offset, int length) {
        int to = offset + length;
        T dto = BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        while (cursor < to) {
            int index = VarIntTool.decodeInt(bytes, cursor);
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(index);
            int fieldLength = VarIntTool.decodeInt(bytes, cursor += VarIntTool.length(index));
            byte[] fieldBytes = Arrays.copyOfRange(bytes, cursor += VarIntTool.length(fieldLength), cursor + fieldLength);
            cursor += fieldBytes.length;
            fieldSchema.decodeIndexed(dto, fieldBytes);
        }
        return dto;
    }
}

