/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.codec.booleancodec.RawBooleanCodec;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import java.util.Arrays;

public class ByteReader {
    private static final RawBooleanCodec RAW_BOOLEAN_CODEC = RawBooleanCodec.INSTANCE;
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private static final ComparableLongCodec COMPARABLE_LONG_CODEC = ComparableLongCodec.INSTANCE;
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;
    private final byte[] bytes;
    private int position;

    public ByteReader(byte[] bytes, int cursor) {
        this.bytes = bytes;
        this.position = cursor;
    }

    public ByteReader(byte[] bytes) {
        this(bytes, 0);
    }

    public int position() {
        return this.position;
    }

    public int skip(int numBytes) {
        this.position += numBytes;
        return this.position;
    }

    public boolean hasMore() {
        return this.position < this.bytes.length;
    }

    public void assertFinished() {
        if (this.position != this.bytes.length) {
            String message = String.format("position %s != bytes.length %s", this.position, this.bytes.length);
            throw new IllegalStateException(message);
        }
    }

    public boolean booleanByte() {
        boolean value = RAW_BOOLEAN_CODEC.decode(this.bytes, this.position);
        ++this.position;
        return value;
    }

    public int skipInts(int num) {
        return this.skip(num * 4);
    }

    public int rawInt() {
        int value = RAW_INT_CODEC.decode(this.bytes, this.position);
        this.position += 4;
        return value;
    }

    public int[] rawInts(int count) {
        int[] value = new int[count];
        int i = 0;
        while (i < count) {
            value[i] = this.rawInt();
            ++i;
        }
        return value;
    }

    public int varInt() {
        int value = VarIntTool.decodeInt(this.bytes, this.position);
        this.position += VarIntTool.length(value);
        return value;
    }

    public int[] varInts(int count) {
        int[] value = new int[count];
        int i = 0;
        while (i < count) {
            value[i] = this.varInt();
            ++i;
        }
        return value;
    }

    public int skipLongs(int num) {
        return this.skip(num * 8);
    }

    public long comparableLong() {
        long value = COMPARABLE_LONG_CODEC.decode(this.bytes, this.position);
        this.position += 8;
        return value;
    }

    public long rawLong() {
        long value = RAW_LONG_CODEC.decode(this.bytes, this.position);
        this.position += 8;
        return value;
    }

    public long[] rawLongs(int count) {
        long[] value = new long[count];
        int i = 0;
        while (i < count) {
            value[i] = this.rawLong();
            ++i;
        }
        return value;
    }

    public long varLong() {
        long value = VarIntTool.decodeLong(this.bytes, this.position);
        this.position += VarIntTool.length(value);
        return value;
    }

    public byte[] bytes(int num) {
        byte[] value = Arrays.copyOfRange(this.bytes, this.position, this.position + num);
        this.position += num;
        return value;
    }

    public byte[] varBytes() {
        int length = this.varInt();
        return this.bytes(length);
    }

    public String comparableUtf8() {
        int terminatorPosition = this.position;
        while (this.bytes[terminatorPosition] != 0) {
            ++terminatorPosition;
        }
        int length = terminatorPosition - this.position;
        String value = StringCodec.UTF_8.decode(this.bytes, this.position, length);
        this.position = terminatorPosition + 1;
        return value;
    }

    public String varUtf8() {
        byte[] bytes = this.varBytes();
        return StringCodec.UTF_8.decode(bytes);
    }
}

