/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.primitivelist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.primitivelist.BasePrimitiveList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;

public class PrimitiveLongList
extends BasePrimitiveList<Long>
implements RandomAccess {
    private static final PrimitiveLongList EMPTY = new PrimitiveLongList(EmptyArray.LONG);
    private final long[] array;

    public PrimitiveLongList(long[] array) {
        this(array, 0, array.length);
    }

    public PrimitiveLongList(long[] array, int from, int to) {
        super(from, to);
        this.array = array;
    }

    public PrimitiveLongList(Collection<Long> values) {
        super(0, values.size());
        this.array = new long[values.size()];
        this.initFromCollection(values);
    }

    public static PrimitiveLongList empty() {
        return EMPTY;
    }

    public Spliterator.OfLong spliterator() {
        return Arrays.spliterator(this.array, this.from, this.to);
    }

    @Override
    protected boolean internalEquals(Object object) {
        if (object instanceof PrimitiveLongList) {
            PrimitiveLongList that = (PrimitiveLongList)object;
            return Arrays.equals(this.array, this.from, this.to, that.array, that.from, that.to);
        }
        return false;
    }

    @Override
    protected int internalFirstIndexOf(Object obj) {
        long value = (Long)obj;
        int i = this.from;
        while (i < this.to) {
            if (this.array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected Long internalGet(int index) {
        return this.array[this.from + index];
    }

    @Override
    protected int internalHashCode() {
        int result = 1;
        int i = this.from;
        while (i < this.to) {
            result = 31 * result + Long.hashCode(this.array[i]);
            ++i;
        }
        return result;
    }

    @Override
    protected boolean internalIsCorrectType(Object object) {
        return object instanceof Long;
    }

    @Override
    protected int internalLastIndexOf(Object obj) {
        long value = (Long)obj;
        int i = this.to - 1;
        while (i >= this.from) {
            if (this.array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    protected Long internalSet(int index, Long value) {
        long oldValue = this.array[index];
        this.array[this.from + index] = value;
        return oldValue;
    }

    @Override
    protected List<Long> internalSubList(int fromIndex, int toIndex) {
        return new PrimitiveLongList(this.array, this.from + fromIndex, this.from + toIndex);
    }
}

