/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.primitivelist;

import io.datarouter.bytes.primitivelist.PrimitiveListTool;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class BasePrimitiveList<T>
extends AbstractList<T>
implements RandomAccess {
    protected static final int NOT_FOUND_INDEX = -1;
    protected final int from;
    protected final int to;

    public BasePrimitiveList(int from, int to) {
        this.from = from;
        this.to = to;
    }

    protected void initFromCollection(Collection<T> values) {
        int cursor = 0;
        for (T value : values) {
            this.set(cursor, value);
            ++cursor;
        }
    }

    abstract int internalFirstIndexOf(Object var1);

    abstract boolean internalEquals(Object var1);

    abstract T internalGet(int var1);

    abstract int internalHashCode();

    abstract boolean internalIsCorrectType(Object var1);

    abstract int internalLastIndexOf(Object var1);

    abstract T internalSet(int var1, T var2);

    abstract List<T> internalSubList(int var1, int var2);

    @Override
    public boolean contains(Object obj) {
        return this.internalIsCorrectType(obj) && this.internalFirstIndexOf(obj) != -1;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.internalEquals(object)) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public T get(int index) {
        PrimitiveListTool.checkIndex(this.size(), index);
        return this.internalGet(index);
    }

    @Override
    public int hashCode() {
        return this.internalHashCode();
    }

    @Override
    public int indexOf(Object obj) {
        int index;
        if (this.internalIsCorrectType(obj) && (index = this.internalFirstIndexOf(obj)) >= 0) {
            return index - this.from;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        int index;
        if (this.internalIsCorrectType(obj) && (index = this.internalLastIndexOf(obj)) >= 0) {
            return index - this.from;
        }
        return -1;
    }

    @Override
    public T set(int index, T value) {
        PrimitiveListTool.checkIndex(this.size(), index);
        Objects.requireNonNull(value);
        return this.internalSet(index, value);
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        PrimitiveListTool.checkSubListIndexes(this.size(), fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return List.of();
        }
        return this.internalSubList(fromIndex, toIndex);
    }
}

