/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.booleanarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.booleancodec.ComparableBooleanCodec;

public class ComparableBooleanArrayCodec {
    public static final ComparableBooleanArrayCodec INSTANCE = new ComparableBooleanArrayCodec();
    private static final ComparableBooleanCodec COMPARABLE_BOOLEAN_CODEC = ComparableBooleanCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_BOOLEAN_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(boolean[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(boolean[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_BOOLEAN_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public boolean[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public boolean[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.BOOLEAN;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        boolean[] result = new boolean[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_BOOLEAN_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

