/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.bytestringcodec;

import io.datarouter.bytes.codec.bytestringcodec.ByteStringCodec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class HexByteStringCodec
implements ByteStringCodec {
    public static final HexByteStringCodec INSTANCE = new HexByteStringCodec();
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    @Override
    public String encode(byte[] bytes) {
        byte[] hexBytes = HexByteStringCodec.toHexBytes(bytes);
        return StringCodec.US_ASCII.decode(hexBytes);
    }

    private static byte[] toHexBytes(byte[] bytes) {
        byte[] hexBytes = new byte[2 * bytes.length];
        int cursor = 0;
        int i = 0;
        while (i < bytes.length) {
            hexBytes[cursor] = HEX_DIGITS[(0xF0 & bytes[i]) >>> 4];
            hexBytes[++cursor] = HEX_DIGITS[0xF & bytes[i]];
            ++cursor;
            ++i;
        }
        return hexBytes;
    }
}

