/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.array;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.array.doublearray.ComparableDoubleArrayCodec;
import java.util.Arrays;

public class DoubleArrayBinaryDtoFieldCodec
extends BinaryDtoBaseFieldCodec<double[]> {
    private static final ComparableDoubleArrayCodec CODEC = ComparableDoubleArrayCodec.INSTANCE;

    @Override
    public byte[] encode(double[] value) {
        byte[] sizeBytes = VarIntTool.encode(value.length);
        byte[] valueBytes = CODEC.encode(value);
        return ByteTool.concat(sizeBytes, valueBytes);
    }

    @Override
    public LengthAndValue<double[]> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        int bytesLength = size * CODEC.itemLength();
        double[] value = CODEC.decode(bytes, cursor += VarIntTool.length(size), bytesLength);
        int length = (cursor += bytesLength) - offset;
        return new LengthAndValue<double[]>(length, value);
    }

    @Override
    public int compareAsIfEncoded(double[] left, double[] right) {
        int sizeDiff = Integer.compare(left.length, right.length);
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        return Arrays.compare(left, right);
    }
}

