/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.floatcodec;

public class RawFloatCodec {
    public static final RawFloatCodec INSTANCE = new RawFloatCodec();
    private static final int LENGTH = 4;

    public int length() {
        return 4;
    }

    public byte[] encode(float value) {
        byte[] bytes = new byte[4];
        this.encode(value, bytes, 0);
        return bytes;
    }

    public int encode(float value, byte[] bytes, int offset) {
        int bits = Float.floatToIntBits(value);
        bytes[offset] = (byte)(bits >>> 24);
        bytes[offset + 1] = (byte)(bits >>> 16);
        bytes[offset + 2] = (byte)(bits >>> 8);
        bytes[offset + 3] = (byte)bits;
        return 4;
    }

    public float decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public float decode(byte[] bytes, int offset) {
        int bits = (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        return Float.intBitsToFloat(bits);
    }
}

