/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.EmptyArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteTool {
    public static final byte[][] EMPTY_ARRAY_2 = new byte[0][];

    public static byte getComparableByte(byte value) {
        if (value >= 0) {
            return (byte)(value + -128);
        }
        return (byte)(value - -128);
    }

    public static byte[] flipToAndFromComparableByteArray(byte[] ins) {
        return ByteTool.flipToAndFromComparableByteArray(ins, 0, ins.length);
    }

    public static byte[] flipToAndFromComparableByteArray(byte[] ins, int offset, int length) {
        byte[] outs = new byte[length];
        int i = 0;
        while (i < length) {
            outs[i] = ByteTool.getComparableByte(ins[offset + i]);
            ++i;
        }
        return outs;
    }

    public static byte[] copyOfRange(byte[] original, int from, int length) {
        int to = from + length;
        return Arrays.copyOfRange(original, from, to);
    }

    public static byte[] unsignedIncrement(byte[] in) {
        if (in.length == 0) {
            throw new IllegalArgumentException("cannot increment empty array");
        }
        byte[] copy = Arrays.copyOf(in, in.length);
        int i = copy.length - 1;
        while (i >= 0) {
            if (copy[i] != -1) {
                int n = i;
                copy[n] = (byte)(copy[n] + 1);
                return copy;
            }
            copy[i] = 0;
            --i;
        }
        byte[] out = new byte[copy.length + 1];
        out[0] = 1;
        System.arraycopy(copy, 0, out, 1, copy.length);
        return out;
    }

    public static byte[] unsignedIncrementOverflowToNull(byte[] in) {
        byte[] out = Arrays.copyOf(in, in.length);
        int i = out.length - 1;
        while (i >= 0) {
            if (out[i] != -1) {
                int n = i;
                out[n] = (byte)(out[n] + 1);
                return out;
            }
            out[i] = 0;
            --i;
        }
        return null;
    }

    public static int totalLength(byte[] ... arrays) {
        int total = 0;
        int i = 0;
        while (i < arrays.length) {
            byte[] array = arrays[i];
            total += array == null ? 0 : array.length;
            ++i;
        }
        return total;
    }

    public static int totalLength(List<byte[]> arrays) {
        int total = 0;
        int i = 0;
        while (i < arrays.size()) {
            byte[] array = arrays.get(i);
            total += array == null ? 0 : array.length;
            ++i;
        }
        return total;
    }

    public static byte[] concat(byte[] ... arrays) {
        byte[] result = new byte[ByteTool.totalLength(arrays)];
        int cursor = 0;
        int i = 0;
        while (i < arrays.length) {
            byte[] array = arrays[i];
            if (array != null) {
                int length = array.length;
                System.arraycopy(array, 0, result, cursor, length);
                cursor += length;
            }
            ++i;
        }
        return result;
    }

    public static byte[] concat(List<byte[]> arrays) {
        byte[] result = new byte[ByteTool.totalLength(arrays)];
        int cursor = 0;
        int i = 0;
        while (i < arrays.size()) {
            byte[] array = arrays.get(i);
            if (array != null) {
                int length = array.length;
                System.arraycopy(array, 0, result, cursor, length);
                cursor += length;
            }
            ++i;
        }
        return result;
    }

    public static byte[] padPrefix(byte[] in, int finalWidth) {
        byte[] out = new byte[finalWidth];
        int numPaddingBytes = finalWidth - in.length;
        System.arraycopy(in, 0, out, numPaddingBytes, in.length);
        return out;
    }

    @Deprecated
    public static ArrayList<Byte> toBoxedBytes(byte[] ins) {
        ArrayList<Byte> outs = new ArrayList<Byte>(ins.length);
        int i = 0;
        while (i < ins.length) {
            outs.add(ins[i]);
            ++i;
        }
        return outs;
    }

    @Deprecated
    public static byte[] fromBoxedBytesNoNegatives(List<Byte> values) {
        if (values.isEmpty()) {
            return EmptyArray.BYTE;
        }
        byte[] out = new byte[values.size()];
        int index = 0;
        for (Byte value : values) {
            if (value < 0) {
                throw new IllegalArgumentException("no negatives");
            }
            out[index] = value;
            ++index;
        }
        return out;
    }
}

