/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.iostream;

import io.datarouter.bytes.InputStreamTool;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoCodec;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import java.io.InputStream;
import java.util.Optional;

public class BinaryDtoInputStreamScanner<T extends BinaryDto<T>>
extends BaseScanner<T> {
    private final BinaryDtoCodec<T> codec;
    private final InputStream inputStream;

    public BinaryDtoInputStreamScanner(Class<T> dtoClass, InputStream inputStream) {
        this.codec = BinaryDtoCodec.of(dtoClass);
        this.inputStream = inputStream;
    }

    public static <T extends BinaryDto<T>> Scanner<T> of(Class<T> dtoClass, InputStream inputStream) {
        return new BinaryDtoInputStreamScanner<T>(dtoClass, inputStream);
    }

    public boolean advance() {
        Optional<Long> size = VarIntTool.fromInputStream(this.inputStream);
        if (size.isEmpty()) {
            return false;
        }
        byte[] dtoBytes = InputStreamTool.readNBytes(this.inputStream, size.get().intValue());
        this.current = this.codec.decode(dtoBytes);
        return true;
    }

    public void close() {
        InputStreamTool.close(this.inputStream);
    }
}

