/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoAllocator;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import io.datarouter.bytes.binarydto.internal.BinaryDtoMetadataParser;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryDtoCodec<T extends BinaryDto<T>> {
    private static final Map<Class<? extends BinaryDto<?>>, BinaryDtoCodec<?>> CACHE = new ConcurrentHashMap();
    public final Class<T> dtoClass;
    public final List<Field> fields;
    public final List<? extends BinaryDtoFieldSchema<?>> fieldSchemas;

    private BinaryDtoCodec(Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        this.fields = new ArrayList<Field>();
        T dto = BinaryDtoAllocator.allocate(dtoClass);
        BinaryDtoMetadataParser<T> metadataParser = new BinaryDtoMetadataParser<T>(dto);
        this.fieldSchemas = metadataParser.scanFieldsOrdered().each(field -> field.setAccessible(true)).each(this.fields::add).map(BinaryDtoFieldSchema::new).list();
    }

    public static <T extends BinaryDto<T>> BinaryDtoCodec<T> of(Class<? extends T> dtoClass) {
        BinaryDtoCodec<Object> codec = CACHE.get(dtoClass);
        if (codec == null) {
            codec = new BinaryDtoCodec<T>(dtoClass);
            CACHE.put(dtoClass, codec);
        }
        return codec;
    }

    public List<Field> getFieldsOrdered() {
        return this.fields;
    }

    public byte[] encode(T dto) {
        return (byte[])Scanner.of(this.fieldSchemas).map(field -> field.encodeField(dto)).listTo(ByteTool::concat);
    }

    public byte[] encodePrefix(T dto, int numFields) {
        return (byte[])Scanner.of(this.fieldSchemas).limit((long)numFields).map(field -> field.encodeField(dto)).listTo(ByteTool::concat);
    }

    public T decode(byte[] bytes) {
        return (T)((BinaryDto)this.decodeWithLength((byte[])bytes, (int)0).value);
    }

    public T decode(byte[] bytes, int offset) {
        return (T)((BinaryDto)this.decodeWithLength((byte[])bytes, (int)offset).value);
    }

    public LengthAndValue<T> decodeWithLength(byte[] bytes) {
        return this.decodeWithLength(bytes, 0);
    }

    public LengthAndValue<T> decodeWithLength(byte[] bytes, int offset) {
        T dto = BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        for (BinaryDtoFieldSchema<?> field : this.fieldSchemas) {
            cursor += field.decodeField(dto, bytes, cursor);
        }
        int length = cursor - offset;
        return new LengthAndValue<T>(length, dto);
    }

    public int decodePrefixLength(byte[] bytes, int offset, int numFields) {
        int cursor = offset;
        int numFieldsDecoded = 0;
        for (BinaryDtoFieldSchema<?> field : this.fieldSchemas) {
            cursor += field.decodeFieldLength(bytes, cursor);
            if (++numFieldsDecoded == numFields) break;
        }
        return cursor - offset;
    }

    public T decodePrefix(byte[] bytes, int offset, int numFields) {
        T dto = BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        int numFieldsDecoded = 0;
        for (BinaryDtoFieldSchema<?> field : this.fieldSchemas) {
            cursor += field.decodeField(dto, bytes, cursor);
            if (++numFieldsDecoded == numFields) break;
        }
        return dto;
    }

    public T deepCopy(T dto) {
        byte[] bytes = this.encode(dto);
        return this.decode(bytes);
    }
}

