/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.EmptyArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteTool {
    public static final byte[][] EMPTY_ARRAY_2 = new byte[0][];

    public static ArrayList<Byte> getArrayList(byte[] ins) {
        ArrayList<Byte> outs = new ArrayList<Byte>(ins.length);
        int i = 0;
        while (i < ins.length) {
            outs.add(ins[i]);
            ++i;
        }
        return outs;
    }

    public static byte getComparableByte(byte value) {
        if (value >= 0) {
            return (byte)(value + -128);
        }
        return (byte)(value - -128);
    }

    public static byte[] flipToAndFromComparableByteArray(byte[] ins) {
        return ByteTool.flipToAndFromComparableByteArray(ins, 0, ins.length);
    }

    public static byte[] flipToAndFromComparableByteArray(byte[] ins, int offset, int length) {
        byte[] outs = new byte[length];
        int i = 0;
        while (i < length) {
            outs[i] = ByteTool.getComparableByte(ins[offset + i]);
            ++i;
        }
        return outs;
    }

    public static byte[] copyOfRange(byte[] original, int from, int length) {
        int to = from + length;
        return Arrays.copyOfRange(original, from, to);
    }

    public static byte[] unsignedIncrement(byte[] in) {
        if (in.length == 0) {
            throw new IllegalArgumentException("cannot increment empty array");
        }
        byte[] copy = Arrays.copyOf(in, in.length);
        int i = copy.length - 1;
        while (i >= 0) {
            if (copy[i] != -1) {
                int n = i;
                copy[n] = (byte)(copy[n] + 1);
                return copy;
            }
            copy[i] = 0;
            --i;
        }
        byte[] out = new byte[copy.length + 1];
        out[0] = 1;
        System.arraycopy(copy, 0, out, 1, copy.length);
        return out;
    }

    public static byte[] unsignedIncrementOverflowToNull(byte[] in) {
        byte[] out = Arrays.copyOf(in, in.length);
        int i = out.length - 1;
        while (i >= 0) {
            if (out[i] != -1) {
                int n = i;
                out[n] = (byte)(out[n] + 1);
                return out;
            }
            out[i] = 0;
            --i;
        }
        return null;
    }

    public static int totalLength(byte[] ... arrays) {
        int total = 0;
        int i = 0;
        while (i < arrays.length) {
            byte[] array = arrays[i];
            total += array == null ? 0 : array.length;
            ++i;
        }
        return total;
    }

    public static byte[] concat(List<byte[]> ins) {
        byte[][] arrays = new byte[ins.size()][];
        int i = 0;
        while (i < ins.size()) {
            arrays[i] = ins.get(i);
            ++i;
        }
        return ByteTool.concat(arrays);
    }

    public static byte[] concat(byte[] ... ins) {
        byte[] out = new byte[ByteTool.totalLength(ins)];
        int startIndex = 0;
        int i = 0;
        while (i < ins.length) {
            byte[] in = ins[i];
            if (in != null) {
                System.arraycopy(in, 0, out, startIndex, in.length);
                startIndex += in.length;
            }
            ++i;
        }
        return out;
    }

    public static byte[] padPrefix(byte[] in, int finalWidth) {
        byte[] out = new byte[finalWidth];
        int numPaddingBytes = finalWidth - in.length;
        System.arraycopy(in, 0, out, numPaddingBytes, in.length);
        return out;
    }

    public static byte[] getUInt7Bytes(List<Byte> values) {
        if (values.isEmpty()) {
            return EmptyArray.BYTE;
        }
        byte[] out = new byte[values.size()];
        int index = 0;
        for (Byte value : values) {
            if (value < 0) {
                throw new IllegalArgumentException("no negatives");
            }
            out[index] = value;
            ++index;
        }
        return out;
    }

    public static byte[] fromUInt7ByteArray(byte[] bytes, int offset, int length) {
        return ByteTool.copyOfRange(bytes, offset, length);
    }
}

