/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.stringcodec;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class TerminatedStringCodec {
    public static final TerminatedStringCodec US_ASCII = new TerminatedStringCodec(StringCodec.US_ASCII);
    public static final TerminatedStringCodec ISO_8859_1 = new TerminatedStringCodec(StringCodec.ISO_8859_1);
    public static final TerminatedStringCodec UTF_8 = new TerminatedStringCodec(StringCodec.UTF_8);
    private static final byte TERMINAL_BYTE = 0;
    private static final byte ESCAPE_BYTE = 1;
    private static final int ESCAPE_SHIFT = 2;
    private final StringCodec stringCodec;

    public TerminatedStringCodec(StringCodec stringCodec) {
        this.stringCodec = stringCodec;
    }

    public byte[] encode(String value) {
        byte[] utf8Bytes = this.stringCodec.encode(value);
        int numToEscape = 0;
        int i = 0;
        while (i < utf8Bytes.length) {
            byte byteI = utf8Bytes[i];
            if (byteI == 0 || byteI == 1) {
                ++numToEscape;
            }
            ++i;
        }
        int escapedLength = utf8Bytes.length + numToEscape;
        byte[] encodedBytes = new byte[escapedLength + 1];
        if (numToEscape == 0) {
            System.arraycopy(utf8Bytes, 0, encodedBytes, 0, utf8Bytes.length);
        } else {
            int utf8Index = 0;
            int escapedIndex = 0;
            while (escapedIndex < escapedLength) {
                byte byteI = utf8Bytes[utf8Index];
                if (byteI == 0 || byteI == 1) {
                    encodedBytes[escapedIndex] = 1;
                    encodedBytes[++escapedIndex] = (byte)(byteI + 2);
                } else {
                    encodedBytes[escapedIndex] = utf8Bytes[utf8Index];
                }
                ++utf8Index;
                ++escapedIndex;
            }
        }
        encodedBytes[encodedBytes.length - 1] = 0;
        return encodedBytes;
    }

    public LengthAndValue<String> decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public LengthAndValue<String> decode(byte[] bytes, int offset) {
        int terminalIndex = offset;
        while (bytes[terminalIndex] != 0) {
            ++terminalIndex;
        }
        int numEscaped = 0;
        int i = offset;
        while (i < terminalIndex - 1) {
            if (bytes[i] == 1) {
                ++numEscaped;
            }
            ++i;
        }
        if (numEscaped == 0) {
            int escapedLength = terminalIndex - offset;
            int consumedLength = escapedLength + 1;
            String value = this.stringCodec.decode(bytes, offset, escapedLength);
            return new LengthAndValue<String>(consumedLength, value);
        }
        int encodedLength = terminalIndex - offset;
        int decodedLength = encodedLength - numEscaped;
        byte[] decodedBytes = new byte[decodedLength];
        int encodedIndex = offset;
        int decodedIndex = 0;
        while (encodedIndex < terminalIndex) {
            decodedBytes[decodedIndex] = bytes[encodedIndex] == 1 ? (byte)(bytes[++encodedIndex] - 2) : bytes[encodedIndex];
            ++encodedIndex;
            ++decodedIndex;
        }
        int consumedLength = terminalIndex - offset + 1;
        String value = this.stringCodec.decode(decodedBytes, 0, decodedLength);
        return new LengthAndValue<String>(consumedLength, value);
    }
}

