/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.scanner.Scanner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;

public class BinaryDtoReflectionTool {
    public static <T> T newInstanceUnchecked(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Scanner<Field> scanFieldsIncludingSuperclasses(Class type) {
        return Scanner.iterate((Object)type, cls -> cls.getSuperclass()).advanceUntil(Objects::isNull).map(Class::getDeclaredFields).concat(fieldArray -> Scanner.of((Object[])fieldArray));
    }

    public static Field getField(Class<?> cls, String fieldName) {
        return BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(cls).include(field -> field.getName().equals(fieldName)).findFirst().orElse(null);
    }

    public static void ensureAccessible(Field field, Object object) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static Object getUnchecked(Field field, Object object) {
        BinaryDtoReflectionTool.ensureAccessible(field, object);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setUnchecked(Field field, Object object, Object value) {
        BinaryDtoReflectionTool.ensureAccessible(field, object);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

