/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.Comparator;

public class BinaryDtoMetadataParser<T extends BinaryDto> {
    private final T dto;

    public BinaryDtoMetadataParser(T dto) {
        this.dto = dto;
    }

    public int numFields() {
        return (int)BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(this.dto.getClass()).count();
    }

    public Scanner<Field> scanFieldsOrdered() {
        return this.anyIndexSpecified() ? this.scanFieldsInAnnotationOrder() : this.scanFieldsInAlphabeticalOrder();
    }

    private Scanner<Field> scanFieldsInAnnotationOrder() {
        int numFields = this.numFields();
        int maxIndex = numFields - 1;
        Object[] orderedFields = new Field[numFields];
        BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(this.dto.getClass()).map(BinaryDtoFieldMetadataParser::new).forEach(arg_0 -> BinaryDtoMetadataParser.lambda$1(maxIndex, (Field[])orderedFields, arg_0));
        return Scanner.of((Object[])orderedFields);
    }

    private Scanner<Field> scanFieldsInAlphabeticalOrder() {
        return BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(this.dto.getClass()).each(field -> {
            if (new BinaryDtoFieldMetadataParser((Field)field).hasIndex()) {
                String message = String.format("Classes extending %s cannot have BinaryDtoField index specified.  Field=%s", this.getClass().getCanonicalName(), field.getName());
                throw new IllegalArgumentException(message);
            }
        }).sort(Comparator.comparing(Field::getName));
    }

    private boolean anyIndexSpecified() {
        return BinaryDtoReflectionTool.scanFieldsIncludingSuperclasses(this.dto.getClass()).map(BinaryDtoFieldMetadataParser::new).anyMatch(BinaryDtoFieldMetadataParser::hasIndex);
    }

    private static /* synthetic */ void lambda$1(int n, Field[] fieldArray, BinaryDtoFieldMetadataParser metadata) {
        int index = metadata.getRequiredIndex();
        if (index < 0) {
            String message = String.format("index=%s cannot be negative", index);
            throw new IllegalArgumentException(message);
        }
        if (index > n) {
            String message = String.format("index=%s is greater than maxIndex=%s", index, n);
            throw new IllegalArgumentException(message);
        }
        if (fieldArray[index] != null) {
            String message = String.format("index=%s already specified", index);
            throw new IllegalArgumentException(message);
        }
        fieldArray[index] = metadata.getField();
    }
}

